package slimeknights.tconstruct.tools.inventory;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.apache.commons.lang3.tuple.Pair;

import slimeknights.mantle.inventory.IContainerCraftingCustom;
import slimeknights.mantle.inventory.SlotCraftingCustom;
import slimeknights.mantle.inventory.SlotOut;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.shared.inventory.InventoryCraftingPersistent;
import slimeknights.tconstruct.tools.block.BlockToolTable;
import slimeknights.tconstruct.tools.client.GuiPartBuilder;
import slimeknights.tconstruct.tools.tileentity.TilePartBuilder;
import slimeknights.tconstruct.tools.tileentity.TilePatternChest;

public class ContainerPartBuilder extends ContainerTinkerStation<TilePartBuilder> implements IContainerCraftingCustom {

  public IInventory craftResult;
  //public IInventory craftResultSecondary;

  private final Slot patternSlot;
  private final Slot secondarySlot;
  private final Slot input1;
  private final Slot input2;

  private final boolean partCrafter;
  public final IInventory patternChest;

  public ContainerPartBuilder(InventoryPlayer playerInventory, TilePartBuilder tile) {
    super(tile);

    InventoryCraftingPersistent craftMatrix = new InventoryCraftingPersistent(this, tile, 1, 3);
    this.craftResult = new InventoryCraftResult();
    //InventoryCrafting craftMatrixSecondary = new InventoryCrafting(this, 1, 1);
    //this.craftResultSecondary = new InventoryCrafting(this, 1, 1);

    // output slots
    this.func_75146_a(new SlotCraftingCustom(this, playerInventory.field_70458_d, craftMatrix, craftResult, 0, 106, 35));
    this.func_75146_a(secondarySlot = new SlotOut(tile, 3, 132, 35));


    // pattern slot
    this.func_75146_a(patternSlot = new SlotStencil(craftMatrix, 2, 26, 35));

    // material slots
    this.func_75146_a(input1 = new Slot(craftMatrix, 0, 48, 26));
    this.func_75146_a(input2 = new Slot(craftMatrix, 1, 48, 44));

    TilePatternChest chest = detectTE(TilePatternChest.class);
    // TE present?
    if(chest != null) {
      // crafting station and stencil table also present?
      boolean hasCraftingStation = false;
      boolean hasStencilTable = false;
      for(Pair<BlockPos, IBlockState> pair : tinkerStationBlocks) {
        if(!pair.getRight().func_177228_b().containsKey(BlockToolTable.TABLES))
          continue;

        BlockToolTable.TableTypes type = (BlockToolTable.TableTypes) pair.getRight().func_177229_b(BlockToolTable.TABLES);
        if(type != null) {
          if(type == BlockToolTable.TableTypes.CraftingStation)
            hasCraftingStation = true;
          else if(type == BlockToolTable.TableTypes.StencilTable)
            hasStencilTable = true;
        }
      }

      // are we a PartCrafter?
      partCrafter = hasStencilTable && hasCraftingStation;

      Container sideInventory = new ContainerPatternChest.DynamicChestInventory(chest, chest, -6, 8, 6);
      addSubContainer(sideInventory, true);

      patternChest = chest;
    }
    else {
      partCrafter = false;
      patternChest = null;
    }

    this.addPlayerInventory(playerInventory, 8, 84);

    func_75130_a(null);
  }

  public boolean isPartCrafter() {
    return partCrafter;
  }

  @Override
  public void func_75130_a(IInventory inventoryIn) {
    updateResult();
  }

  // Sets the result in the output slot depending on the input!
  public void updateResult() {
    // no pattern -> no output
    if(!patternSlot.func_75216_d() || (!input1.func_75216_d() && !input2.func_75216_d() && !secondarySlot.func_75216_d())) {
      craftResult.func_70299_a(0, null);
      updateGUI();
    }
    else {
      Throwable throwable = null;
      ItemStack[] toolPart;
      try {
        toolPart = ToolBuilder.tryBuildToolPart(patternSlot.func_75211_c(), new ItemStack[]{input1.func_75211_c(),
                                                                                        input2.func_75211_c()}, false);
      } catch(TinkerGuiException e) {
        toolPart = null;
        throwable = e;
      }

      ItemStack secondary = secondarySlot.func_75211_c();

      // got output?
      if(toolPart != null &&
         // got no secondary output or does it stack with the current one?
         (secondary == null || toolPart[1] == null || ItemStack.func_179545_c(secondary, toolPart[1]) && ItemStack.func_77970_a(secondary, toolPart[1]))) {
          craftResult.func_70299_a(0, toolPart[0]);
      }
      else {
        craftResult.func_70299_a(0, null);
      }

      if(throwable != null) {
        error(throwable.getMessage());
      }
      else {
        updateGUI();
      }
    }
  }

  /** Looks for a pattern that matches the given one in the PatternChest and exchanges it with the pattern slot */
  public void setPattern(ItemStack wanted) {
    if(patternChest == null)
      return;

    // check chest contents for wanted
    for(int i = 0; i < patternChest.func_70302_i_(); i++) {
      if(ItemStack.func_77989_b(wanted, patternChest.func_70301_a(i))) {
        // found it! exchange it with the pattern slot!
        ItemStack slotStack = patternSlot.func_75211_c();
        patternSlot.func_75215_d(patternChest.func_70301_a(i));
        patternChest.func_70299_a(i, slotStack);
        break;
      }
    }
  }

  @Override
  public void onCrafting(EntityPlayer player, ItemStack output, IInventory craftMatrix) {
    ItemStack[] toolPart = new ItemStack[0];
    try {
      toolPart = ToolBuilder.tryBuildToolPart(patternSlot.func_75211_c(), new ItemStack[]{input1.func_75211_c(),
                                                                                      input2.func_75211_c()}, true);
    } catch(TinkerGuiException e) {
      // don't need any user information at this stage
    }
    if(toolPart == null) {
      // undefined :I
      return;
    }

    ItemStack secondary = secondarySlot.func_75211_c();
    if(secondary == null) {
      func_75141_a(secondarySlot.field_75222_d, toolPart[1]);
    }
    else if(toolPart[1] != null && ItemStack.func_179545_c(secondary, toolPart[1]) && ItemStack.func_77970_a(secondary, toolPart[1])) {
      secondary.field_77994_a += toolPart[1].field_77994_a;
    }

    // clean up 0 size stacks
    for(int i = 0; i < craftMatrix.func_70302_i_(); i++) {
      if(craftMatrix.func_70301_a(i) != null && craftMatrix.func_70301_a(i).field_77994_a == 0) {
        craftMatrix.func_70299_a(i, null);
      }
    }

    updateResult();
  }

  @Override
  public boolean func_94530_a(ItemStack p_94530_1_, Slot p_94530_2_) {
    // prevents that doubleclicking on an item pulls the same out of the crafting slot
    return p_94530_2_.field_75224_c != this.craftResult && super.func_94530_a(p_94530_1_, p_94530_2_);
  }

  public IChatComponent getInventoryDisplayName() {
    if(partCrafter) {
      return new ChatComponentTranslation("gui.partcrafter.name");
    }

    return super.getInventoryDisplayName();
  }

  @Override
  @SideOnly(Side.CLIENT)
  public void func_75141_a(int p_75141_1_, ItemStack p_75141_2_) {
    super.func_75141_a(p_75141_1_, p_75141_2_);

    // this is called solely to update the gui buttons
    Minecraft mc = Minecraft.func_71410_x();
    if(mc.field_71462_r instanceof GuiPartBuilder) {
      ((GuiPartBuilder) mc.field_71462_r).updateButtons();
    }
  }

  @Override
  @SideOnly(Side.CLIENT)
  public ItemStack func_75144_a(int slotId, int clickedButton, int mode, EntityPlayer playerIn) {
    ItemStack ret = super.func_75144_a(slotId, clickedButton, mode, playerIn);
    // this is called solely to update the gui buttons
    Minecraft mc = Minecraft.func_71410_x();
    if(mc.field_71462_r instanceof GuiPartBuilder) {
      ((GuiPartBuilder) mc.field_71462_r).updateButtons();
    }

    return ret;
  }
}
