package slimeknights.tconstruct.library.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;

import net.minecraft.item.ItemStack;

import java.util.List;

import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.MaterialItem;

public class MaterialMatch extends RecipeMatch {

  private final Material material;

  public MaterialMatch(Material material, int amountNeeded, int amountMatched) {
    super(amountMatched, amountMatched);
    this.material = material;
  }

  public MaterialMatch(Material material, int amountNeeded) {
    this(material, amountNeeded, 2);
  }

  public MaterialMatch(Material material) {
    this(material, 1, 2);
  }

  @Override
  public List<ItemStack> getInputs() {
    return ImmutableList.of(); // todo
  }

  @Override
  public Match matches(ItemStack[] stacks) {
    List<ItemStack> found = Lists.newLinkedList();
    int stillNeeded = amountNeeded;

    for(ItemStack stack : stacks) {

      if(stack.func_77973_b() instanceof MaterialItem) {
        if(material == ((MaterialItem) stack.func_77973_b()).getMaterial(stack)) {
          // add the amount found to the list
          ItemStack copy = stack.func_77946_l();
          copy.field_77994_a = Math.min(copy.field_77994_a, stillNeeded);
          found.add(copy);
          stillNeeded -= copy.field_77994_a;

          // we found enough
          if(stillNeeded <= 0) {
            return new Match(found, amountMatched);
          }
        }
      }
    }

    return null;
  }
}
