package slimeknights.tconstruct.gadgets.item;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.SlimeBounceHandler;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.tools.network.EntityMovementChangePacket;

public class ItemSlimeSling extends Item {

  public ItemSlimeSling() {
    this.func_77625_d(1);
    this.func_77637_a(TinkerRegistry.tabGadgets);
  }

  /**
   * Called whenever this item is equipped and the right mouse button is pressed. Args: itemStack, world, entityPlayer
   */
  public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn)
  {
    playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
    return itemStackIn;
  }

  @Override
  public EnumAction func_77661_b(ItemStack stack) {
    return EnumAction.BOW;
  }

  @Override
  public int func_77626_a(ItemStack stack) {
    return 72000;
  }

  // sling logic
  @Override
  public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int timeLeft) {
    // has to be on ground to do something
    if(!player.field_70122_E) {
      return;
    }

    // copy chargeup code from bow \o/
    int i = this.func_77626_a(stack) - timeLeft;
    float f = (float)i / 20.0F;
    f = (f * f + f * 2.0F) / 3.0F;
    f *= 4f;

    if(f > 6f) {
      f = 6f;
    }

    // check if player was targeting a block
    MovingObjectPosition mop = func_77621_a(world, player, false);

    if(mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
      // we fling the inverted player look vector
      Vec3 vec = player.func_70040_Z().func_72432_b();

      player.func_70024_g(vec.field_72450_a * -f,
                         vec.field_72448_b * -f/3f,
                         vec.field_72449_c * -f);

      if(player instanceof EntityPlayerMP) {
        EntityPlayerMP playerMP = (EntityPlayerMP) player;
        TinkerNetwork.sendTo(new EntityMovementChangePacket(player), playerMP);
        //playerMP.playerNetServerHandler.sendPacket(new S12PacketEntityVelocity(player));
      }
      player.func_85030_a(Sounds.slimesling, 1f, 1f);
      SlimeBounceHandler.addBounceHandler(player);
      //TinkerCommons.potionSlimeBounce.apply(player);
    }
  }
}
