/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameData;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.tools.IPattern;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.utils.TagUtil;

public class Pattern
extends Item
implements IPattern {
    public static final DecimalFormat df = new DecimalFormat("#.##");
    public static final String TAG_PARTTYPE = "PartType";

    public Pattern() {
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabParts);
        this.setHasSubtypes(true);
    }

    public void getSubItems(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(new ItemStack((Item)this));
        for (Item toolpart : TinkerRegistry.getPatternItems()) {
            ItemStack stack = new ItemStack((Item)this);
            Pattern.setTagForPart(stack, toolpart);
            subItems.add(stack);
        }
    }

    public String getItemStackDisplayName(ItemStack stack) {
        Item part = Pattern.getPartFromTag(stack);
        String unloc = this.getUnlocalizedNameInefficiently(stack);
        if (part == null) {
            return Util.translate(unloc + ".blank", new Object[0]);
        }
        return Util.translateFormatted(unloc + ".name", part.getItemStackDisplayName(null));
    }

    public static void setTagForPart(ItemStack stack, Item toolPart) {
        NBTTagCompound tag = TagUtil.getTagSafe(stack);
        tag.setString(TAG_PARTTYPE, toolPart.getRegistryName());
        stack.setTagCompound(tag);
    }

    public static Item getPartFromTag(ItemStack stack) {
        NBTTagCompound tag = TagUtil.getTagSafe(stack);
        String part = tag.getString(TAG_PARTTYPE);
        return (Item)GameData.getItemRegistry().getObject(new ResourceLocation(part));
    }

    public boolean isBlankPattern(ItemStack stack) {
        if (stack == null || !(stack.getItem() instanceof IPattern)) {
            return false;
        }
        if (!stack.hasTagCompound()) {
            return true;
        }
        return Config.reuseStencil || !stack.getTagCompound().hasKey(TAG_PARTTYPE);
    }

    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        Item part = Pattern.getPartFromTag(stack);
        if (part != null && part instanceof IToolPart) {
            float cost = (float)((IToolPart)part).getCost() / 144.0f;
            tooltip.add(Util.translateFormatted("tooltip.pattern.cost", df.format(cost)));
        }
    }

    public static String getTextureIdentifier(Item item) {
        String identifier = item.getRegistryName();
        if (identifier.contains(":")) {
            identifier = identifier.substring(identifier.lastIndexOf(58) + 1);
        }
        return "_" + identifier;
    }
}

