/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;

public class TextureColoredTexture
extends AbstractColoredTexture {
    protected final TextureAtlasSprite addTexture;
    protected final String addTextureLocation;
    protected int[][] textureData;
    protected int textureW;
    protected int textureH;
    protected float scale;
    protected int offsetX = 0;
    protected int offsetY = 0;
    public boolean stencil = false;

    public TextureColoredTexture(String addTextureLocation, TextureAtlasSprite baseTexture, String spriteName) {
        super(baseTexture, spriteName);
        this.addTextureLocation = addTextureLocation;
        this.addTexture = null;
    }

    public TextureColoredTexture(TextureAtlasSprite addTexture, TextureAtlasSprite baseTexture, String spriteName) {
        super(baseTexture, spriteName);
        this.addTextureLocation = addTexture.getIconName();
        this.addTexture = addTexture;
    }

    @Override
    protected int colorPixel(int pixel, int mipmap, int pxCoord) {
        int a = RenderUtil.alpha(pixel);
        if (a == 0) {
            return pixel;
        }
        if (this.textureData == null) {
            this.loadData();
        }
        int texCoord = pxCoord;
        if (this.width > this.textureW) {
            int texX = pxCoord % this.width % this.textureW;
            int texY = pxCoord / this.height % this.textureH;
            texCoord = texY * this.textureW + texX;
        }
        int c = this.textureData[mipmap][texCoord];
        int r = RenderUtil.red(c);
        int b = RenderUtil.blue(c);
        int g = RenderUtil.green(c);
        if (!this.stencil) {
            r = TextureColoredTexture.mult(TextureColoredTexture.mult(r, RenderUtil.red(pixel)), RenderUtil.red(pixel));
            g = TextureColoredTexture.mult(TextureColoredTexture.mult(g, RenderUtil.green(pixel)), RenderUtil.green(pixel));
            b = TextureColoredTexture.mult(TextureColoredTexture.mult(b, RenderUtil.blue(pixel)), RenderUtil.blue(pixel));
        }
        return RenderUtil.compose(r, g, b, a);
    }

    protected void loadData() {
        if (this.addTexture != null && this.addTexture.getFrameCount() > 0) {
            this.textureData = this.addTexture.getFrameTextureData(0);
            this.scale = (float)this.addTexture.getIconWidth() / (float)this.width;
            this.textureW = this.addTexture.getIconWidth();
            this.textureH = this.addTexture.getIconHeight();
        } else {
            int w = this.width;
            int h = this.height;
            this.textureData = this.backupLoadTexture(new ResourceLocation(this.addTextureLocation), Minecraft.getMinecraft().getResourceManager());
            this.scale = (float)this.width / (float)w;
            this.textureW = this.width;
            this.textureH = this.height;
            this.width = w;
            this.height = h;
        }
    }

    public void setOffset(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
    }

    protected int coord2(int x, int y) {
        return y * this.textureW + x;
    }
}

