/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;

public class SimpleColoredTexture
extends AbstractColoredTexture {
    protected final int colorLow;
    protected final int colorMid;
    protected final int colorHigh;
    int minBrightness;
    int maxBrightness;
    float weight = 0.6f;

    public SimpleColoredTexture(int colorLow, int colorMid, int colorHigh, TextureAtlasSprite baseTexture, String spriteName) {
        super(baseTexture, spriteName);
        this.colorLow = colorLow;
        this.colorMid = colorMid;
        this.colorHigh = colorHigh;
    }

    @Override
    protected void processData(int[][] data) {
        int max = 0;
        int min = 255;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int c = data[0][y * this.width + x];
                if (RenderUtil.alpha(c) == 0) continue;
                int b = SimpleColoredTexture.getPerceptualBrightness(c);
                if (b < min) {
                    min = b;
                }
                if (b <= max) continue;
                max = b;
            }
        }
        int d = max - min;
        this.minBrightness = Math.max(min + 1, min + (int)((float)(d /= 2) * 0.4f));
        this.maxBrightness = Math.min(max - 1, max - (int)((float)d * 0.3f));
        super.processData(data);
    }

    @Override
    protected int colorPixel(int pixel, int mipmap, int pxCoord) {
        int a = RenderUtil.alpha(pixel);
        if (a == 0) {
            return pixel;
        }
        int brightness = SimpleColoredTexture.getPerceptualBrightness(pixel);
        int c = this.colorMid;
        if (brightness < this.minBrightness) {
            c = this.colorLow;
        } else if (brightness > this.maxBrightness) {
            c = this.colorHigh;
        }
        int r = RenderUtil.red(c);
        int b = RenderUtil.blue(c);
        int g = RenderUtil.green(c);
        r = SimpleColoredTexture.mult(r, RenderUtil.red(pixel)) & 0xFF;
        g = SimpleColoredTexture.mult(g, RenderUtil.blue(pixel)) & 0xFF;
        b = SimpleColoredTexture.mult(b, RenderUtil.green(pixel)) & 0xFF;
        return RenderUtil.compose(r, g, b, a);
    }
}

