/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.inventory.IContainerCraftingCustom;
import slimeknights.mantle.inventory.SlotCraftingCustom;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.inventory.InventoryCraftingPersistent;
import slimeknights.tconstruct.tools.inventory.ContainerPatternChest;
import slimeknights.tconstruct.tools.inventory.ContainerTinkerStation;
import slimeknights.tconstruct.tools.inventory.SlotStencil;
import slimeknights.tconstruct.tools.network.StencilTableSelectionPacket;
import slimeknights.tconstruct.tools.tileentity.TilePatternChest;
import slimeknights.tconstruct.tools.tileentity.TileStencilTable;

public class ContainerStencilTable
extends ContainerTinkerStation<TileStencilTable>
implements IContainerCraftingCustom {
    public InventoryCraftingPersistent craftMatrix;
    public IInventory craftResult;
    private ItemStack output;
    private final Container patternChestSideInventory;

    public ContainerStencilTable(InventoryPlayer playerInventory, TileStencilTable tile) {
        super(tile);
        this.craftMatrix = new InventoryCraftingPersistent((Container)this, (IInventory)tile, 1, 1);
        this.craftResult = new InventoryCraftResult();
        this.addSlotToContainer(new SlotStencil((IInventory)this.craftMatrix, 0, 48, 35));
        this.addSlotToContainer((Slot)new SlotCraftingCustom((IContainerCraftingCustom)this, playerInventory.player, (InventoryCrafting)this.craftMatrix, this.craftResult, 1, 106, 35));
        TilePatternChest chest = (TilePatternChest)this.detectTE(TilePatternChest.class);
        if (chest != null) {
            this.patternChestSideInventory = new ContainerPatternChest.DynamicChestInventory(chest, (IInventory)chest, 182, 8, 6);
            this.addSubContainer(this.patternChestSideInventory, true);
        } else {
            this.patternChestSideInventory = null;
        }
        this.addPlayerInventory(playerInventory, 8, 84);
        this.onCraftMatrixChanged(null);
    }

    protected void syncWithOtherContainer(BaseContainer<TileStencilTable> otherContainer, EntityPlayerMP player) {
        this.syncWithOtherContainer((ContainerStencilTable)otherContainer, player);
    }

    protected void syncWithOtherContainer(ContainerStencilTable otherContainer, EntityPlayerMP player) {
        this.setOutput(otherContainer.output);
        if (this.output != null) {
            TinkerNetwork.sendTo((AbstractPacket)new StencilTableSelectionPacket(this.output), player);
        }
    }

    public void setOutput(ItemStack stack) {
        if (stack == null) {
            return;
        }
        for (ItemStack candidate : TinkerRegistry.getStencilTableCrafting()) {
            if (!ItemStack.areItemStacksEqual((ItemStack)stack, (ItemStack)candidate)) continue;
            this.output = stack;
            this.updateResult();
            return;
        }
    }

    public void onCraftMatrixChanged(IInventory inventoryIn) {
        this.updateResult();
    }

    public void updateResult() {
        if (this.craftMatrix.getStackInSlot(0) == null || this.output == null) {
            this.craftResult.setInventorySlotContents(0, null);
        } else {
            this.craftResult.setInventorySlotContents(0, this.output.copy());
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer playerIn, int index) {
        if (index != 1) {
            return super.transferStackInSlot(playerIn, index);
        }
        Slot slot = (Slot)this.inventorySlots.get(index);
        if (slot == null || !slot.getHasStack()) {
            return null;
        }
        ItemStack itemstack = slot.getStack().copy();
        ItemStack ret = slot.getStack().copy();
        if (this.patternChestSideInventory != null) {
            if (this.moveToContainer(itemstack, this.patternChestSideInventory)) {
                return null;
            }
            return this.notifySlotAfterTransfer(playerIn, itemstack, ret, slot);
        }
        return super.transferStackInSlot(playerIn, index);
    }

    public void onCrafting(EntityPlayer player, ItemStack output, IInventory craftMatrix) {
        ItemStack itemstack1 = craftMatrix.getStackInSlot(0);
        if (itemstack1 != null) {
            craftMatrix.decrStackSize(0, 1);
        }
        this.updateResult();
    }

    public boolean canMergeSlot(ItemStack p_94530_1_, Slot p_94530_2_) {
        return p_94530_2_.inventory != this.craftResult && super.canMergeSlot(p_94530_1_, p_94530_2_);
    }
}

