/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client.module;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import slimeknights.mantle.client.gui.GuiModule;
import slimeknights.mantle.client.gui.GuiMultiModule;

public class GuiSideButtons
extends GuiModule {
    private final int columns;
    private GuiButton clickedButton;
    public int spacing = 4;

    public GuiSideButtons(GuiMultiModule parent, Container container, int columns) {
        this(parent, container, columns, false);
    }

    public GuiSideButtons(GuiMultiModule parent, Container container, int columns, boolean right) {
        super(parent, container, right, false);
        this.columns = columns;
    }

    public void addButton(GuiButton button) {
        int count = this.buttonList.size();
        int rows = (count - 1) / this.columns + 1;
        this.xSize = button.width * this.columns + this.spacing * (this.columns - 1);
        this.ySize = button.height * rows + this.spacing * (rows - 1);
        int offset = this.buttonList.size();
        int x = offset % this.columns * (button.width + this.spacing);
        int y = offset / this.columns * (button.height + this.spacing);
        button.xPosition = this.guiLeft + x;
        button.yPosition = this.guiTop + y;
        if (this.right) {
            button.xPosition += this.parent.xSize;
        }
        this.buttonList.add(button);
    }

    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            for (Object o : this.buttonList) {
                GuiButton guibutton = (GuiButton)o;
                if (!guibutton.mousePressed(this.mc, mouseX, mouseY)) continue;
                this.clickedButton = guibutton;
                guibutton.playPressSound(this.mc.getSoundHandler());
                this.actionPerformed(guibutton);
                return true;
            }
        }
        return false;
    }

    public boolean handleMouseReleased(int mouseX, int mouseY, int state) {
        if (this.clickedButton != null) {
            this.clickedButton.mouseReleased(mouseX, mouseY);
            this.clickedButton = null;
            return true;
        }
        return false;
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        for (Object o : this.buttonList) {
            ((GuiButton)o).drawButton(this.mc, mouseX, mouseY);
        }
    }
}

