/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.Point;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiElementScalable;
import slimeknights.mantle.client.gui.GuiModule;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.TinkerRegistryClient;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.ToolBuildGuiInfo;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.client.GuiButtonRepair;
import slimeknights.tconstruct.tools.client.GuiTinkerStation;
import slimeknights.tconstruct.tools.client.module.GuiButtonsToolStation;
import slimeknights.tconstruct.tools.client.module.GuiInfoPanel;
import slimeknights.tconstruct.tools.inventory.ContainerTinkerStation;
import slimeknights.tconstruct.tools.inventory.ContainerToolStation;
import slimeknights.tconstruct.tools.inventory.SlotToolStationIn;
import slimeknights.tconstruct.tools.network.ToolStationSelectionPacket;
import slimeknights.tconstruct.tools.network.ToolStationTextPacket;
import slimeknights.tconstruct.tools.tileentity.TileToolStation;

@SideOnly(value=Side.CLIENT)
public class GuiToolStation
extends GuiTinkerStation {
    private static final ResourceLocation BACKGROUND = Util.getResource("textures/gui/toolstation.png");
    private static final GuiElement TextFieldActive = new GuiElement(0, 210, 102, 12, 256, 256);
    private static final GuiElement ItemCover = new GuiElement(176, 18, 80, 64);
    private static final GuiElement SlotBackground = new GuiElement(176, 0, 18, 18);
    private static final GuiElement SlotBorder = new GuiElement(194, 0, 18, 18);
    private static final GuiElement SlotSpaceTop = new GuiElement(0, 176, 18, 2);
    private static final GuiElement SlotSpaceBottom = new GuiElement(0, 174, 18, 2);
    private static final GuiElement PanelSpaceL = new GuiElement(0, 174, 5, 4);
    private static final GuiElement PanelSpaceR = new GuiElement(9, 174, 9, 4);
    private static final GuiElement BeamLeft = new GuiElement(0, 180, 2, 7);
    private static final GuiElement BeamRight = new GuiElement(131, 180, 2, 7);
    private static final GuiElementScalable BeamCenter = new GuiElementScalable(2, 180, 129, 7);
    public static final int Column_Count = 5;
    private static final int Table_slot_count = 6;
    protected GuiElement buttonDecorationTop = SlotSpaceTop;
    protected GuiElement buttonDecorationBot = SlotSpaceBottom;
    protected GuiElement panelDecorationL = PanelSpaceL;
    protected GuiElement panelDecorationR = PanelSpaceR;
    protected GuiElement beamL = new GuiElement(0, 0, 0, 0);
    protected GuiElement beamR = new GuiElement(0, 0, 0, 0);
    protected GuiElementScalable beamC = new GuiElementScalable(0, 0, 0, 0);
    protected GuiButtonsToolStation buttons;
    protected int activeSlots;
    public GuiTextField textField;
    protected GuiInfoPanel toolInfo;
    protected GuiInfoPanel traitInfo;
    public ToolBuildGuiInfo currentInfo = GuiButtonRepair.info;

    public GuiToolStation(InventoryPlayer playerInv, World world, BlockPos pos, TileToolStation tile) {
        super(world, pos, (ContainerTinkerStation)tile.createContainer(playerInv, world, pos));
        this.buttons = new GuiButtonsToolStation(this, this.inventorySlots);
        this.addModule(this.buttons);
        this.toolInfo = new GuiInfoPanel(this, this.inventorySlots);
        this.addModule(this.toolInfo);
        this.traitInfo = new GuiInfoPanel(this, this.inventorySlots);
        this.addModule(this.traitInfo);
        this.toolInfo.yOffset = 5;
        this.traitInfo.yOffset = this.toolInfo.ySize + 9;
        this.ySize = 174;
        this.wood();
    }

    public void initGui() {
        super.initGui();
        Keyboard.enableRepeatEvents((boolean)true);
        this.guiTop += 4;
        this.cornerY += 4;
        this.textField = new GuiTextField(0, this.fontRendererObj, this.cornerX + 70, this.cornerY + 7, 92, 12);
        this.textField.setEnableBackgroundDrawing(false);
        this.textField.setMaxStringLength(40);
        this.buttons.xOffset = -2;
        this.buttons.yOffset = this.beamC.h + this.buttonDecorationTop.h;
        this.toolInfo.xOffset = 2;
        this.toolInfo.yOffset = this.beamC.h + this.panelDecorationL.h;
        this.traitInfo.xOffset = this.toolInfo.xOffset;
        this.traitInfo.yOffset = this.toolInfo.yOffset + this.toolInfo.ySize + 4;
        for (GuiModule module : this.modules) {
            module.guiTop += 4;
        }
        this.updateGUI();
    }

    public void onGuiClosed() {
        super.onGuiClosed();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public Set<ToolCore> getBuildableItems() {
        return TinkerRegistry.getToolStationCrafting();
    }

    public void onToolSelection(ToolBuildGuiInfo info) {
        this.activeSlots = Math.min(info.positions.size(), 6);
        this.currentInfo = info;
        ToolCore tool = null;
        if (info.tool != null && info.tool.getItem() instanceof ToolCore) {
            tool = (ToolCore)info.tool.getItem();
        }
        ((ContainerToolStation)this.inventorySlots).setToolSelection(tool, this.activeSlots);
        TinkerNetwork.sendToServer((AbstractPacket)new ToolStationSelectionPacket(tool, this.activeSlots));
        this.updateGUI();
    }

    public void onToolSelectionPacket(ToolStationSelectionPacket packet) {
        ToolBuildGuiInfo info = TinkerRegistryClient.getToolBuildInfoForTool(packet.tool);
        if (info == null) {
            info = GuiButtonRepair.info;
        }
        this.activeSlots = packet.activeSlots;
        this.currentInfo = info;
        this.buttons.setSelectedButtonByTool(this.currentInfo.tool);
        this.updateGUI();
    }

    public void updateGUI() {
        Slot slot;
        int i;
        for (i = 0; i < this.activeSlots; ++i) {
            Point point = this.currentInfo.positions.get(i);
            slot = this.inventorySlots.getSlot(i);
            slot.xDisplayPosition = point.getX();
            slot.yDisplayPosition = point.getY();
        }
        int stillFilled = 0;
        while (i < 6) {
            slot = this.inventorySlots.getSlot(i);
            if (slot.getHasStack()) {
                slot.xDisplayPosition = 87 + 20 * stillFilled;
                slot.yDisplayPosition = 62;
                ++stillFilled;
            } else {
                slot.xDisplayPosition = 0;
                slot.yDisplayPosition = 0;
            }
            ++i;
        }
        this.updateDisplay();
    }

    @Override
    public void updateDisplay() {
        ContainerToolStation container = (ContainerToolStation)this.inventorySlots;
        ItemStack toolStack = container.getResult();
        if (toolStack == null) {
            toolStack = this.inventorySlots.getSlot(0).getStack();
        }
        if (toolStack != null && toolStack.getItem() instanceof ToolCore) {
            ToolCore tool = (ToolCore)toolStack.getItem();
            this.toolInfo.setCaption(tool.getLocalizedToolName());
            this.toolInfo.setText(tool.getInformation(toolStack));
            this.traitInfo.setCaption(StatCollector.translateToLocal((String)"gui.toolstation.traits"));
            LinkedList mods = Lists.newLinkedList();
            LinkedList tips = Lists.newLinkedList();
            NBTTagList tagList = TagUtil.getModifiersTagList(toolStack);
            for (int i = 0; i < tagList.tagCount(); ++i) {
                NBTTagCompound tag = tagList.getCompoundTagAt(i);
                ModifierNBT data = ModifierNBT.readTag(tag);
                IModifier modifier = TinkerRegistry.getModifier(data.identifier);
                if (modifier == null || modifier.isHidden()) continue;
                mods.add(data.getColorString() + modifier.getTooltip(tag, true));
                tips.add(data.getColorString() + modifier.getLocalizedDesc());
            }
            if (mods.isEmpty()) {
                mods.add(StatCollector.translateToLocal((String)"gui.toolstation.noTraits"));
            }
            this.traitInfo.setText(mods, tips);
        } else if (this.currentInfo.tool == null) {
            this.toolInfo.setCaption(StatCollector.translateToLocal((String)"gui.toolstation.repair"));
            this.toolInfo.setText(new String[0]);
            this.traitInfo.setCaption(null);
            String c = EnumChatFormatting.DARK_GRAY.toString();
            String[] art = new String[]{c + "", c + "", c + "       .", c + "     /( _________", c + "     |  >:=========`", c + "     )(  ", c + "     \"\""};
            this.traitInfo.setText(art);
        } else {
            ToolCore tool = (ToolCore)this.currentInfo.tool.getItem();
            this.toolInfo.setCaption(tool.getLocalizedToolName());
            this.toolInfo.setText(tool.getLocalizedDescription());
            LinkedList text = Lists.newLinkedList();
            List<PartMaterialType> pms = tool.getRequiredComponents();
            for (int i = 0; i < pms.size(); ++i) {
                PartMaterialType pmt = pms.get(i);
                StringBuilder sb = new StringBuilder();
                ItemStack slotStack = container.getSlot(i).getStack();
                if (!pmt.isValid(slotStack)) {
                    sb.append(EnumChatFormatting.RED);
                    if (slotStack != null && slotStack.getItem() instanceof IToolPart && pmt.isValidItem((IToolPart)slotStack.getItem())) {
                        this.warning(Util.translate("gui.error.wrong_material_part", new Object[0]));
                    }
                }
                sb.append(" * ");
                for (IToolPart part : pmt.getPossibleParts()) {
                    if (!(part instanceof Item)) continue;
                    sb.append(((Item)part).getItemStackDisplayName(new ItemStack((Item)part)));
                    sb.append("/");
                }
                sb.deleteCharAt(sb.length() - 1);
                text.add(sb.toString());
            }
            this.traitInfo.setCaption(StatCollector.translateToLocal((String)"gui.toolstation.components"));
            this.traitInfo.setText(text.toArray(new String[text.size()]));
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.textField.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        if (!this.textField.isFocused()) {
            super.keyTyped(typedChar, keyCode);
        } else {
            if (keyCode == 1) {
                this.mc.thePlayer.closeScreen();
            }
            this.textField.textboxKeyTyped(typedChar, keyCode);
            TinkerNetwork.sendToServer((AbstractPacket)new ToolStationTextPacket(this.textField.getText()));
            ((ContainerToolStation)this.container).setToolName(this.textField.getText());
        }
    }

    public void updateScreen() {
        super.updateScreen();
        this.textField.updateCursorCounter();
    }

    public void drawSlot(Slot slotIn) {
        if (slotIn instanceof SlotToolStationIn && ((SlotToolStationIn)slotIn).isDormant() && !slotIn.getHasStack()) {
            return;
        }
        super.drawSlot(slotIn);
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        int i;
        this.drawBackground(BACKGROUND);
        if (this.textField.isFocused()) {
            TextFieldActive.draw(this.cornerX + 68, this.cornerY + 6);
        }
        this.textField.drawTextBox();
        int x = 0;
        int y = 0;
        float scale = 3.7f;
        float xOff = 10.0f;
        float yOff = 22.0f;
        GlStateManager.translate((float)10.0f, (float)22.0f, (float)0.0f);
        GlStateManager.scale((float)3.7f, (float)3.7f, (float)1.0f);
        int logoX = (int)((float)this.cornerX / 3.7f);
        int logoY = (int)((float)this.cornerY / 3.7f);
        if (this.currentInfo != null) {
            if (this.currentInfo.tool != null) {
                this.itemRender.renderItemIntoGUI(this.currentInfo.tool, logoX, logoY);
            } else if (this.currentInfo == GuiButtonRepair.info) {
                this.mc.getTextureManager().bindTexture(ICONS);
                ICON_Anvil.draw(logoX, logoY);
            }
        }
        GlStateManager.scale((float)0.27027026f, (float)0.27027026f, (float)1.0f);
        GlStateManager.translate((float)-10.0f, (float)-22.0f, (float)0.0f);
        this.mc.getTextureManager().bindTexture(BACKGROUND);
        GlStateManager.enableBlend();
        GlStateManager.enableAlpha();
        RenderHelper.disableStandardItemLighting();
        GlStateManager.disableDepth();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)0.82f);
        ItemCover.draw(this.cornerX + 7, this.cornerY + 18);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)0.28f);
        for (i = 0; i < this.activeSlots; ++i) {
            Slot slot = this.inventorySlots.getSlot(i);
            SlotBackground.draw(x + this.cornerX + slot.xDisplayPosition - 1, y + this.cornerY + slot.yDisplayPosition - 1);
        }
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (i = 0; i < 6; ++i) {
            Slot slot = this.inventorySlots.getSlot(i);
            if (!(slot instanceof SlotToolStationIn) || ((SlotToolStationIn)slot).isDormant() && !slot.getHasStack()) continue;
            SlotBorder.draw(x + this.cornerX + slot.xDisplayPosition - 1, y + this.cornerY + slot.yDisplayPosition - 1);
        }
        this.mc.getTextureManager().bindTexture(ICONS);
        if (this.currentInfo == GuiButtonRepair.info) {
            this.drawRepairSlotIcons();
        } else if (this.currentInfo.tool != null && this.currentInfo.tool.getItem() instanceof TinkersItem) {
            for (i = 0; i < this.activeSlots; ++i) {
                ItemStack stack;
                Slot slot = this.inventorySlots.getSlot(i);
                if (!(slot instanceof SlotToolStationIn) || (stack = ((SlotToolStationIn)slot).icon) == null) continue;
                this.itemRender.renderItemIntoGUI(stack, x + this.cornerX + slot.xDisplayPosition, y + this.cornerY + slot.yDisplayPosition);
            }
        }
        this.mc.getTextureManager().bindTexture(BACKGROUND);
        x = this.buttons.guiLeft - this.beamL.w;
        y = this.cornerY;
        x += this.beamL.draw(x, y);
        x += this.beamC.drawScaledX(x, y, this.buttons.xSize);
        this.beamR.draw(x, y);
        x = this.toolInfo.guiLeft - this.beamL.w;
        x += this.beamL.draw(x, y);
        x += this.beamC.drawScaledX(x, y, this.toolInfo.xSize);
        this.beamR.draw(x, y);
        for (Object o : this.buttons.buttonList) {
            GuiButton button = (GuiButton)o;
            this.buttonDecorationTop.draw(button.xPosition, button.yPosition - this.buttonDecorationTop.h);
            if (button.id >= this.buttons.buttonList.size() - 5) continue;
            this.buttonDecorationBot.draw(button.xPosition, button.yPosition + button.height);
        }
        this.panelDecorationL.draw(this.toolInfo.guiLeft + 5, this.toolInfo.guiTop - this.panelDecorationL.h);
        this.panelDecorationR.draw(this.toolInfo.guiRight() - 5 - this.panelDecorationR.w, this.toolInfo.guiTop - this.panelDecorationR.h);
        this.panelDecorationL.draw(this.traitInfo.guiLeft + 5, this.traitInfo.guiTop - this.panelDecorationL.h);
        this.panelDecorationR.draw(this.traitInfo.guiRight() - 5 - this.panelDecorationR.w, this.traitInfo.guiTop - this.panelDecorationR.h);
        GlStateManager.enableDepth();
        super.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
    }

    protected void drawRepairSlotIcons() {
        for (int i = 0; i < this.activeSlots; ++i) {
            this.drawRepairSlotIcon(i);
        }
    }

    protected void drawRepairSlotIcon(int i) {
        GuiElement icon = null;
        Slot slot = this.inventorySlots.getSlot(i);
        if (slot.getHasStack()) {
            return;
        }
        if (i == 0) {
            icon = ICON_Pickaxe;
        } else if (i == 1) {
            icon = ICON_Dust;
        } else if (i == 2) {
            icon = ICON_Lapis;
        } else if (i == 3) {
            icon = ICON_Ingot;
        } else if (i == 4) {
            icon = ICON_Gem;
        } else if (i == 5) {
            icon = ICON_Quartz;
        }
        if (icon != null) {
            this.drawIconEmpty(slot, icon);
        }
    }

    protected void wood() {
        this.toolInfo.wood();
        this.traitInfo.wood();
        this.buttonDecorationTop = SlotSpaceTop.shift(GuiToolStation.SlotSpaceTop.w, 0);
        this.buttonDecorationBot = SlotSpaceBottom.shift(GuiToolStation.SlotSpaceBottom.w, 0);
        this.panelDecorationL = PanelSpaceL.shift(18, 0);
        this.panelDecorationR = PanelSpaceR.shift(18, 0);
        this.buttons.wood();
        this.beamL = BeamLeft;
        this.beamR = BeamRight;
        this.beamC = BeamCenter;
    }

    protected void metal() {
        this.toolInfo.metal();
        this.traitInfo.metal();
        this.buttonDecorationTop = SlotSpaceTop.shift(GuiToolStation.SlotSpaceTop.w * 2, 0);
        this.buttonDecorationBot = SlotSpaceBottom.shift(GuiToolStation.SlotSpaceBottom.w * 2, 0);
        this.panelDecorationL = PanelSpaceL.shift(36, 0);
        this.panelDecorationR = PanelSpaceR.shift(36, 0);
        this.buttons.metal();
        this.beamL = BeamLeft.shift(0, GuiToolStation.BeamLeft.h);
        this.beamR = BeamRight.shift(0, GuiToolStation.BeamRight.h);
        this.beamC = BeamCenter.shift(0, GuiToolStation.BeamCenter.h);
    }

    @Override
    public void error(String message) {
        this.toolInfo.setCaption(StatCollector.translateToLocal((String)"gui.error"));
        this.toolInfo.setText(message);
        this.traitInfo.setCaption(null);
        this.traitInfo.setText(new String[0]);
    }

    @Override
    public void warning(String message) {
        this.toolInfo.setCaption(StatCollector.translateToLocal((String)"gui.warning"));
        this.toolInfo.setText(message);
        this.traitInfo.setCaption(null);
        this.traitInfo.setText(new String[0]);
    }
}

