/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.world.TinkerWorld;

public class BlockSoil
extends EnumBlock<SoilTypes> {
    public static final PropertyEnum<SoilTypes> TYPE = PropertyEnum.create((String)"type", SoilTypes.class);

    public BlockSoil() {
        super(Material.sand, TYPE, SoilTypes.class);
        this.slipperiness = 0.8f;
        this.setHardness(3.0f);
        this.setStepSound(soundTypeSand);
        this.setHarvestLevel("Shovel", -1);
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabGeneral);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (SoilTypes type : SoilTypes.values()) {
            if (!this.isTypeEnabled(type)) continue;
            list.add(new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    protected boolean isTypeEnabled(SoilTypes type) {
        switch (type) {
            case GROUT: {
                return TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery");
            }
            case SLIMY_MUD_BLUE: {
                return TinkerCommons.matSlimeBallBlue != null;
            }
            case SLIMY_MUD_MAGMA: {
                return TinkerCommons.matSlimeBallMagma != null;
            }
            case MUDBRICK: {
                return TinkerCommons.mudBrick != null;
            }
            case SLIMY_MUD_GREEN: 
            case GRAVEYARD: 
            case CONSECRATED: {
                return true;
            }
        }
        return false;
    }

    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, Entity entityIn) {
        IBlockState state = worldIn.getBlockState(pos);
        switch ((SoilTypes)((Object)state.getValue(TYPE))) {
            case SLIMY_MUD_BLUE: 
            case SLIMY_MUD_GREEN: {
                this.processSlimyMud(entityIn);
                break;
            }
            case GRAVEYARD: {
                this.processGraveyardSoil(entityIn);
                break;
            }
            case CONSECRATED: {
                this.processConsecratedSoil(entityIn);
            }
        }
    }

    protected void processSlimyMud(Entity entity) {
        entity.motionX *= 0.4;
        entity.motionZ *= 0.4;
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).addPotionEffect(new PotionEffect(Potion.weakness.id, 1));
        }
    }

    protected void processConsecratedSoil(Entity entity) {
        EntityLivingBase entityLiving;
        if (entity instanceof EntityLiving && (entityLiving = (EntityLivingBase)entity).getCreatureAttribute() == EnumCreatureAttribute.UNDEAD) {
            entityLiving.attackEntityFrom(DamageSource.magic, 1.0f);
            entityLiving.setFire(1);
        }
    }

    protected void processGraveyardSoil(Entity entity) {
        EntityLivingBase entityLiving;
        if (entity instanceof EntityLiving && (entityLiving = (EntityLivingBase)entity).getCreatureAttribute() == EnumCreatureAttribute.UNDEAD) {
            entityLiving.heal(1.0f);
        }
    }

    public boolean canSustainPlant(IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        SoilTypes type = (SoilTypes)((Object)world.getBlockState(pos).getValue(TYPE));
        if (type == SoilTypes.SLIMY_MUD_GREEN || type == SoilTypes.SLIMY_MUD_BLUE) {
            return plantable.getPlantType(world, pos) == TinkerWorld.slimePlantType;
        }
        return super.canSustainPlant(world, pos, direction, plantable);
    }

    public static enum SoilTypes implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        GROUT,
        SLIMY_MUD_GREEN,
        SLIMY_MUD_BLUE,
        GRAVEYARD,
        CONSECRATED,
        SLIMY_MUD_MAGMA,
        MUDBRICK;

        public final int meta = this.ordinal();

        public String getName() {
            return this.toString();
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

