/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.IAoeTool;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.traits.InfiTool;
import slimeknights.tconstruct.tools.traits.ToolGrowth;

public abstract class ToolCore
extends TinkersItem {
    protected static final int DEFAULT_MODIFIERS = 3;
    protected static final ToolGrowth toolGrowth = new ToolGrowth();

    public ToolCore(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabTools);
        this.setNoRepair();
        TinkerRegistry.registerTool(this);
        this.addCategory(Category.TOOL);
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolHelper.getDurabilityStat(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, damage);
        if (this.getDamage(stack) == this.getMaxDamage(stack)) {
            ToolHelper.breakTool(stack, null);
        }
    }

    public boolean isDamageable() {
        return true;
    }

    public float miningSpeedModifier() {
        return 1.0f;
    }

    public abstract float damagePotential();

    public float damageCutoff() {
        return 15.0f;
    }

    public int attackSpeed() {
        return 0;
    }

    public float knockback() {
        return 1.0f;
    }

    public boolean dealDamage(ItemStack stack, EntityPlayer player, EntityLivingBase entity, float damage) {
        return entity.attackEntityFrom(DamageSource.causePlayerDamage((EntityPlayer)player), damage);
    }

    public void reduceDurabilityOnHit(ItemStack stack, EntityPlayer player, float damage) {
        damage = Math.max(1.0f, damage / 10.0f);
        if (!this.hasCategory(Category.WEAPON)) {
            damage *= 2.0f;
        }
        ToolHelper.damageTool(stack, (int)damage, (EntityLivingBase)player);
    }

    public float getDigSpeed(ItemStack itemstack, IBlockState state) {
        if (this.isEffective(state.getBlock()) || ToolHelper.isToolEffective(itemstack, state)) {
            return ToolHelper.calcDigSpeed(itemstack, state);
        }
        return super.getDigSpeed(itemstack, state);
    }

    public boolean isEffective(Block block) {
        return false;
    }

    public boolean canHarvestBlock(Block block, ItemStack itemStack) {
        return this.isEffective(block);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (this instanceof IAoeTool && ((IAoeTool)((Object)this)).isAoeHarvestTool() && ToolHelper.isToolEffective2(itemstack, player.worldObj.getBlockState(pos))) {
            for (BlockPos extraPos : ((IAoeTool)((Object)this)).getAOEBlocks(itemstack, player.worldObj, player, pos)) {
                ToolHelper.breakExtraBlock(itemstack, player.worldObj, player, extraPos, pos);
            }
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return ToolHelper.attackEntity(stack, this, player, entity);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (this.attackSpeed() > 0) {
            int speed = Math.min(5, this.attackSpeed());
            ToolHelper.swingItem(speed, entityLiving);
            return true;
        }
        return super.onEntitySwing(entityLiving, stack);
    }

    public boolean canUseSecondaryItem() {
        return true;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.canUseSecondaryItem()) {
            return ToolHelper.useSecondaryItem(stack, playerIn, worldIn, pos, side, hitX, hitY, hitZ);
        }
        return super.onItemUse(stack, playerIn, worldIn, pos, side, hitX, hitY, hitZ);
    }

    public boolean hitEntity(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (this.attackSpeed() > 0) {
            target.hurtResistantTime -= this.attackSpeed();
            target.hurtTime -= this.attackSpeed();
        }
        return super.hitEntity(stack, target, attacker);
    }

    @Override
    public List<String> getInformation(ItemStack stack) {
        return this.getInformation(stack, true);
    }

    @Override
    public void getTooltip(ItemStack stack, List<String> tooltips) {
        if (ToolHelper.isBroken(stack)) {
            tooltips.add("" + EnumChatFormatting.DARK_RED + EnumChatFormatting.BOLD + Util.translate("tooltip.tool.broken", new Object[0]));
        }
        super.getTooltip(stack, tooltips);
    }

    @Override
    public void getTooltipDetailed(ItemStack stack, List<String> tooltips) {
        tooltips.addAll(this.getInformation(stack, false));
    }

    public List<String> getInformation(ItemStack stack, boolean detailed) {
        TooltipBuilder info = new TooltipBuilder(stack);
        info.addDurability(!detailed);
        if (this.hasCategory(Category.HARVEST)) {
            info.addHarvestLevel();
            info.addMiningSpeed();
        }
        info.addAttack();
        if (ToolHelper.getFreeModifiers(stack) > 0) {
            info.addFreeModifiers();
        }
        if (detailed) {
            info.addModifierInfo();
        }
        return info.getTooltip();
    }

    @Override
    public void getTooltipComponents(ItemStack stack, List<String> tooltips) {
        List<Material> materials = TinkerUtil.getMaterialsFromTagList(TagUtil.getBaseMaterialsTagList(stack));
        List<PartMaterialType> component = this.getRequiredComponents();
        if (materials.size() < component.size()) {
            return;
        }
        for (int i = 0; i < component.size(); ++i) {
            IToolPart part;
            ItemStack partStack;
            PartMaterialType pmt = component.get(i);
            Material material = materials.get(i);
            Iterator<IToolPart> partIter = pmt.getPossibleParts().iterator();
            if (!partIter.hasNext() || (partStack = (part = partIter.next()).getItemstackWithMaterial(material)) == null) continue;
            tooltips.add(material.getTextColor() + EnumChatFormatting.UNDERLINE + partStack.getDisplayName());
            for (IMaterialStats stats : material.getAllStats()) {
                if (!pmt.usesStat(stats.getIdentifier())) continue;
                tooltips.addAll(stats.getLocalizedInfo());
                for (ITrait trait : pmt.getApplicableTraitsForMaterial(material)) {
                    tooltips.add(material.getTextColor() + trait.getLocalizedName());
                }
            }
            tooltips.add("");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.fontRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack) {
        return TagUtil.hasEnchantEffect(stack);
    }

    public String getItemStackDisplayName(ItemStack stack) {
        List<Material> materials = TinkerUtil.getMaterialsFromTagList(TagUtil.getBaseMaterialsTagList(stack));
        LinkedHashSet nameMaterials = Sets.newLinkedHashSet();
        for (int index : this.getRepairParts()) {
            if (index >= materials.size()) continue;
            nameMaterials.add(materials.get(index));
        }
        String itemName = super.getItemStackDisplayName(stack);
        if (nameMaterials.isEmpty()) {
            return itemName;
        }
        if (nameMaterials.size() == 1) {
            return ((Material)((Object)nameMaterials.iterator().next())).getLocalizedItemName(itemName);
        }
        StringBuilder sb = new StringBuilder();
        Iterator iter = nameMaterials.iterator();
        Material material = (Material)((Object)iter.next());
        sb.append(material.getLocalizedName());
        while (iter.hasNext()) {
            material = (Material)((Object)iter.next());
            sb.append("-");
            sb.append(material.getLocalizedName());
        }
        sb.append(" ");
        sb.append(itemName);
        return sb.toString();
    }

    public void getSubItems(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        this.addDefaultSubItems(subItems);
    }

    protected void addDefaultSubItems(List<ItemStack> subItems) {
        for (Material head : TinkerRegistry.getAllMaterials()) {
            if (!head.hasStats("head")) continue;
            ArrayList<Material> mats = new ArrayList<Material>(this.requiredComponents.length);
            for (int i = 0; i < this.requiredComponents.length; ++i) {
                mats.add(head);
            }
            ItemStack tool = this.buildItem(mats);
            if (!this.hasValidMaterials(tool)) continue;
            subItems.add(tool);
        }
    }

    protected void addInfiTool(List<ItemStack> subitems, String name) {
        ItemStack tool = this.getInfiTool(name);
        if (this.hasValidMaterials(tool)) {
            subitems.add(tool);
        }
    }

    protected ItemStack getInfiTool(String name) {
        Object materials = ImmutableList.of((Object)((Object)TinkerMaterials.slime), (Object)((Object)TinkerMaterials.cobalt), (Object)((Object)TinkerMaterials.ardite), (Object)((Object)TinkerMaterials.ardite));
        materials = materials.subList(0, this.requiredComponents.length);
        ItemStack tool = this.buildItem((List<Material>)materials);
        InfiTool.INSTANCE.apply(tool);
        tool.setStackDisplayName(name);
        return tool;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (this.getToolClasses(stack).contains(toolClass)) {
            NBTTagCompound tag = TagUtil.getToolTag(stack);
            return ToolHelper.getHarvestLevelStat(stack);
        }
        return super.getHarvestLevel(stack, toolClass);
    }

    public String getIdentifier() {
        return Util.getItemLocation(this).getResourcePath();
    }

    public String getLocalizedToolName() {
        return Util.translate(this.getUnlocalizedName() + ".name", new Object[0]);
    }

    public String getLocalizedToolName(Material material) {
        return material.getLocalizedItemName(this.getLocalizedToolName());
    }

    public String getLocalizedDescription() {
        return Util.translate(this.getUnlocalizedName() + ".desc", new Object[0]);
    }

    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.onUpdate(stack, worldIn, entityIn, itemSlot, isSelected);
        NBTTagList list = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < list.tagCount(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(list.getStringTagAt(i));
            if (trait == null) continue;
            trait.onUpdate(stack, worldIn, entityIn, itemSlot, isSelected);
        }
    }

    public boolean onBlockDestroyed(ItemStack stack, World worldIn, Block blockIn, BlockPos pos, EntityLivingBase playerIn) {
        if (ToolHelper.isBroken(stack)) {
            return false;
        }
        boolean effective = this.isEffective(blockIn) || ToolHelper.isToolEffective(stack, worldIn.getBlockState(pos));
        int damage = effective ? 1 : 2;
        this.afterBlockBreak(stack, worldIn, blockIn, pos, playerIn, damage, effective);
        return this.hasCategory(Category.TOOL);
    }

    public void afterBlockBreak(ItemStack stack, World world, Block block, BlockPos pos, EntityLivingBase player, int damage, boolean wasEffective) {
        NBTTagList list = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < list.tagCount(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(list.getStringTagAt(i));
            if (trait == null) continue;
            trait.afterBlockBreak(stack, world, block, pos, player, wasEffective);
        }
        ToolHelper.damageTool(stack, damage, player);
    }

    public MovingObjectPosition getMovingObjectPositionFromPlayer(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        return super.getMovingObjectPositionFromPlayer(worldIn, playerIn, useLiquids);
    }

    protected void preventSlowDown(Entity entityIn, float originalSpeed) {
        TinkerTools.proxy.preventPlayerSlowdown(entityIn, originalSpeed, this);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    protected ToolNBT buildDefaultTag(List<Material> materials) {
        ToolNBT data = new ToolNBT();
        if (materials.size() >= 2) {
            HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
            HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
            data.head(head);
            if (materials.size() >= 3) {
                ExtraMaterialStats binding = (ExtraMaterialStats)materials.get(2).getStatsOrUnknown("extra");
                data.extra(binding);
            }
            data.handle(handle);
        }
        data.modifiers = 3;
        return data;
    }

    static {
        TinkerRegistry.addTrait(toolGrowth);
    }
}

