/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.TRSRTransformation;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.client.model.BakedMaterialModel;
import slimeknights.tconstruct.library.client.model.IPatternOffset;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.materials.Material;

public class MaterialModel
extends ItemLayerModel
implements IPatternOffset {
    protected final int offsetX;
    protected final int offsetY;

    public MaterialModel(ImmutableList<ResourceLocation> textures) {
        this(textures, 0, 0);
    }

    public MaterialModel(ImmutableList<ResourceLocation> textures, int offsetX, int offsetY) {
        super(textures);
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public IFlexibleBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return this.bakeIt(state, format, bakedTextureGetter);
    }

    public BakedMaterialModel bakeIt(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        if (this.offsetX != 0 || this.offsetY != 0) {
            state = new ModelStateComposition(state, (IModelState)TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f((float)this.offsetX / 16.0f, (float)(-this.offsetY) / 16.0f, 0.0f), null, null, null)));
        }
        ImmutableMap map = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
        IFlexibleBakedModel base = super.bake(state, format, bakedTextureGetter);
        BakedMaterialModel bakedMaterialModel = new BakedMaterialModel(base, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map);
        String baseTexture = base.getParticleTexture().getIconName();
        Map<String, TextureAtlasSprite> sprites = CustomTextureCreator.sprites.get(baseTexture);
        for (Map.Entry<String, TextureAtlasSprite> entry : sprites.entrySet()) {
            Material material = TinkerRegistry.getMaterial(entry.getKey());
            IModel model2 = this.retexture(ImmutableMap.of((Object)"layer0", (Object)entry.getValue().getIconName()));
            IFlexibleBakedModel bakedModel2 = model2.bake(state, format, bakedTextureGetter);
            if (material.renderInfo.useVertexColoring() && !CustomTextureCreator.exists(baseTexture + "_" + material.identifier)) {
                int color = material.renderInfo.getVertexColor();
                ImmutableList.Builder quads = ImmutableList.builder();
                for (BakedQuad quad : bakedModel2.getGeneralQuads()) {
                    quads.add((Object)ModelHelper.colorQuad(color, quad));
                }
                bakedModel2 = new ItemLayerModel.BakedModel(quads.build(), bakedModel2.getParticleTexture(), bakedModel2.getFormat());
            }
            if (!map.isEmpty()) {
                bakedModel2 = new IPerspectiveAwareModel.MapWrapper(bakedModel2, map);
            }
            bakedMaterialModel.addMaterialModel(material, bakedModel2);
        }
        return bakedMaterialModel;
    }

    public IModelState getDefaultState() {
        return ModelHelper.DEFAULT_ITEM_STATE;
    }

    @Override
    public int getXOffset() {
        return this.offsetX;
    }

    @Override
    public int getYOffset() {
        return this.offsetY;
    }
}

