/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.entity;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import slimeknights.tconstruct.gadgets.TinkerGadgets;

public class EntityFancyItemFrame
extends EntityItemFrame
implements IEntityAdditionalSpawnData {
    private FrameType type;

    public EntityFancyItemFrame(World worldIn, BlockPos p_i45852_2_, EnumFacing p_i45852_3_, int meta) {
        this(worldIn, p_i45852_2_, p_i45852_3_, FrameType.fromMeta(meta));
    }

    public EntityFancyItemFrame(World worldIn, BlockPos p_i45852_2_, EnumFacing p_i45852_3_, FrameType type) {
        super(worldIn, p_i45852_2_, p_i45852_3_);
        this.type = type;
    }

    public EntityFancyItemFrame(World worldIn) {
        super(worldIn);
    }

    public void dropItemOrSelf(Entity entity, boolean dropFrame) {
        if (this.worldObj.getGameRules().getBoolean("doEntityDrops")) {
            ItemStack itemstack = this.getDisplayedItem();
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                if (entityplayer.capabilities.isCreativeMode) {
                    this.removeFrameFromMap(itemstack);
                    return;
                }
            }
            if (dropFrame) {
                this.entityDropItem(new ItemStack((Item)TinkerGadgets.fancyFrame, 1, this.type.ordinal()), 0.0f);
            }
            if (itemstack != null) {
                itemstack = itemstack.copy();
                this.removeFrameFromMap(itemstack);
                this.entityDropItem(itemstack, 0.0f);
            }
        }
    }

    public String getName() {
        if (this.hasCustomName()) {
            return this.getCustomNameTag();
        }
        ItemStack foo = new ItemStack((Item)TinkerGadgets.fancyFrame, 1, this.type.ordinal());
        return foo.getDisplayName();
    }

    public void writeEntityToNBT(NBTTagCompound tagCompound) {
        int nr = this.type != null ? this.type.ordinal() : 0;
        tagCompound.setInteger("frame", nr);
        super.writeEntityToNBT(tagCompound);
    }

    public void readEntityFromNBT(NBTTagCompound tagCompund) {
        int nr = tagCompund.getInteger("frame");
        this.type = FrameType.values()[nr % FrameType.values().length];
        super.readEntityFromNBT(tagCompund);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeShort(this.facingDirection.getHorizontalIndex());
        buffer.writeShort(this.type != null ? this.type.ordinal() : 0);
    }

    public void readSpawnData(ByteBuf additionalData) {
        EnumFacing facing = EnumFacing.getHorizontal((int)additionalData.readShort());
        this.updateFacingWithBoundingBox(facing);
        this.type = FrameType.values()[additionalData.readShort()];
    }

    public String getType() {
        if (this.type == null) {
            return FrameType.JEWEL.toString();
        }
        return this.type.toString();
    }

    public static enum FrameType {
        JEWEL,
        ALUBRASS,
        COBALT,
        ARDITE,
        MANYULLYN,
        GOLD;


        public static FrameType fromMeta(int meta) {
            return FrameType.values()[meta % FrameType.values().length];
        }
    }
}

