/*
 * Decompiled with CFR 0.152.
 */
package paintedstone;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.oredict.OreDictionary;
import paintedstone.PHPaint;
import paintedstone.PaintedStoneBlock;
import paintedstone.PaintedStoneItem;
import paintedstone.TabPaintedStone;

@Mod(modid="PaintedStone", name="Painted Stone", version="Beacon")
public class PaintedStone {
    public static final String[] dyeTypes = new String[]{"white", "orange", "magenta", "lightblue", "yellow", "lime", "pink", "gray", "lightgray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    public static CreativeTabs tab;
    private boolean TConstruct;
    public static Block coloredStone;
    public static Block coloredCobble;
    public static Block coloredMossCobble;
    public static Block coloredStoneBrick;
    public static Block coloredMossStoneBrick;
    public static Block coloredCrackedStoneBrick;
    public static Block coloredStoneRoad;
    public static Block coloredStoneFancyBrick;
    public static Block coloredStoneSquareBrick;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PHPaint.initProps(event.getSuggestedConfigurationFile());
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.TConstruct = Loader.isModLoaded((String)"TConstruct");
        tab = new TabPaintedStone("paintedstone");
        coloredCobble = new PaintedStoneBlock(Material.rock, 2.0f, "stone_cobble", "stone.cobble").setBlockName("paintedstone.cobble");
        GameRegistry.registerBlock((Block)coloredCobble, PaintedStoneItem.class, (String)"paintedstone.cobble", (String)"PaintedStone", (Object[])new Object[0]);
        coloredStone = new PaintedStoneBlock(Material.rock, 1.5f, "stone_raw", "stone.raw", coloredCobble).setBlockName("paintedstone.raw");
        GameRegistry.registerBlock((Block)coloredStone, PaintedStoneItem.class, (String)"paintedstone.raw", (String)"PaintedStone", (Object[])new Object[0]);
        coloredMossCobble = new PaintedStoneBlock(Material.rock, 2.0f, "stone_mosscobble", "stone.mosscobble").setBlockName("paintedstone.mosscobble");
        GameRegistry.registerBlock((Block)coloredMossCobble, PaintedStoneItem.class, (String)"paintedstone.mosscobble", (String)"PaintedStone", (Object[])new Object[0]);
        coloredStoneBrick = new PaintedStoneBlock(Material.rock, 1.5f, "stone_brick", "stone.brick").setBlockName("paintedstone.brick");
        GameRegistry.registerBlock((Block)coloredStoneBrick, PaintedStoneItem.class, (String)"paintedstone.brick", (String)"PaintedStone", (Object[])new Object[0]);
        coloredMossStoneBrick = new PaintedStoneBlock(Material.rock, 1.5f, "stone_mossbrick", "stone.mossbrick").setBlockName("paintedstone.mossbrick");
        GameRegistry.registerBlock((Block)coloredMossStoneBrick, PaintedStoneItem.class, (String)"paintedstone.mossbrick", (String)"PaintedStone", (Object[])new Object[0]);
        coloredCrackedStoneBrick = new PaintedStoneBlock(Material.rock, 1.5f, "stone_crackedbrick", "stone.crackedbrick").setBlockName("paintedstone.crackedbrick");
        GameRegistry.registerBlock((Block)coloredCrackedStoneBrick, PaintedStoneItem.class, (String)"paintedstone.crackedbrick", (String)"PaintedStone", (Object[])new Object[0]);
        coloredStoneRoad = new PaintedStoneBlock(Material.rock, 1.5f, "stone_road", "stone.road").setBlockName("paintedstone.road");
        GameRegistry.registerBlock((Block)coloredStoneRoad, PaintedStoneItem.class, (String)"paintedstone.road", (String)"PaintedStone", (Object[])new Object[0]);
        coloredStoneFancyBrick = new PaintedStoneBlock(Material.rock, 1.5f, "stone_fancy", "stone.fancy").setBlockName("paintedstone.fancy");
        GameRegistry.registerBlock((Block)coloredStoneFancyBrick, PaintedStoneItem.class, (String)"paintedstone.fancy", (String)"PaintedStone", (Object[])new Object[0]);
        coloredStoneSquareBrick = new PaintedStoneBlock(Material.rock, 1.5f, "stone_square", "stone.chiseled").setBlockName("paintedstone.chiseled");
        GameRegistry.registerBlock((Block)coloredStoneSquareBrick, PaintedStoneItem.class, (String)"paintedstone.chiseled", (String)"PaintedStone", (Object[])new Object[0]);
        for (int i = 0; i < 16; ++i) {
            FurnaceRecipes.smelting().func_151393_a(coloredCobble, new ItemStack(coloredStone, 1, i), 0.2f);
            GameRegistry.addRecipe((ItemStack)new ItemStack(coloredStoneBrick, 4, i), (Object[])new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(coloredStone, 1, i)});
            int oreID = OreDictionary.getOreID((String)"stone");
            OreDictionary.registerOre((int)oreID, (ItemStack)new ItemStack(coloredStone, 1, i));
            oreID = OreDictionary.getOreID((String)"cobblestone");
            OreDictionary.registerOre((int)oreID, (ItemStack)new ItemStack(coloredCobble, 1, i));
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent event) {
        ItemStack stack;
        String type;
        EntityPlayer player = event.entityPlayer;
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && (type = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)(stack = player.getCurrentEquippedItem())))) != null) {
            type = type.toLowerCase();
            for (int i = 0; i < 16; ++i) {
                if (!type.equals("dye" + dyeTypes[i])) continue;
                if (!this.colorStoneBlocks(player.worldObj, event.x, event.y, event.z, i)) break;
                if (!player.capabilities.isCreativeMode) {
                    --stack.stackSize;
                    if (stack.stackSize <= 0) {
                        player.destroyCurrentEquippedItem();
                    }
                }
                player.swingItem();
                if (player.worldObj.isRemote) break;
                Block block = Blocks.stone;
                player.worldObj.playSoundEffect((double)((float)event.x + 0.5f), (double)((float)event.y + 0.5f), (double)((float)event.z + 0.5f), block.stepSound.func_150496_b(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                break;
            }
        }
    }

    public boolean colorStoneBlocks(World world, int x, int y, int z, int inputMeta) {
        boolean changed = false;
        int range = 1;
        for (int xPos = -range; xPos <= range; ++xPos) {
            for (int yPos = -range; yPos <= range; ++yPos) {
                for (int zPos = -range; zPos <= range; ++zPos) {
                    Block block = world.getBlock(x + xPos, y + yPos, z + zPos);
                    if (block == Blocks.stone) {
                        changed = true;
                        world.setBlock(x + xPos, y + yPos, z + zPos, coloredStone, inputMeta, 3);
                        continue;
                    }
                    if (block == Blocks.cobblestone) {
                        changed = true;
                        world.setBlock(x + xPos, y + yPos, z + zPos, coloredCobble, inputMeta, 3);
                        continue;
                    }
                    if (block == Blocks.mossy_cobblestone) {
                        changed = true;
                        world.setBlock(x + xPos, y + yPos, z + zPos, coloredMossCobble, inputMeta, 3);
                        continue;
                    }
                    if (block != Blocks.stonebrick) continue;
                    changed = true;
                    int meta = world.getBlockMetadata(x + xPos, y + yPos, z + zPos);
                    if (meta == 0) {
                        world.setBlock(x + xPos, y + yPos, z + zPos, coloredStoneBrick, inputMeta, 3);
                        continue;
                    }
                    if (meta == 1) {
                        world.setBlock(x + xPos, y + yPos, z + zPos, coloredCrackedStoneBrick, inputMeta, 3);
                        continue;
                    }
                    if (meta == 2) {
                        world.setBlock(x + xPos, y + yPos, z + zPos, coloredMossStoneBrick, inputMeta, 3);
                        continue;
                    }
                    if (meta != 3) continue;
                    world.setBlock(x + xPos, y + yPos, z + zPos, coloredStoneSquareBrick, inputMeta, 3);
                }
            }
        }
        return changed;
    }
}

