/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.entities.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityNitroCreeper
extends EntityCreeper {
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 12;
    private int explosionRadius = 1;

    public EntityNitroCreeper(World world) {
        super(world);
        this.field_70178_ae = true;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (!this.field_70170_p.field_72995_K) {
            if (distance > 5.0f) {
                this.explode();
            } else {
                super.func_180430_e(distance, damageMultiplier);
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74777_a("Fuse", (short)this.fuseTime);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuseTime = compound.func_74765_d("Fuse");
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int powered;
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.func_146078_ca()) {
                this.func_70829_a(1);
            }
            if ((i = this.func_70832_p()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            int difficulty = this.field_70170_p.func_175659_aa().func_151525_a();
            int n = powered = this.func_70830_n() ? 12 : 0;
            if (this.timeSinceIgnited >= this.fuseTime + difficulty + powered) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            float f = this.func_70830_n() ? 20.0f : 3.0f;
            this.field_70729_aU = true;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionRadius * f, flag);
            this.func_70106_y();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70831_j(float partialTickTime) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * partialTickTime) / (float)(this.fuseTime - 2);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_76346_g() instanceof EntityIronGolem) {
            amount = 1000.0f;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        int item;
        int numberOfTimes;
        Item dropItem = this.func_146068_u();
        if (dropItem != null) {
            numberOfTimes = this.field_70146_Z.nextInt(4) + 2;
            if (lootingModifier > 0) {
                numberOfTimes += this.field_70146_Z.nextInt(lootingModifier + 1);
            }
            for (item = 0; item < numberOfTimes; ++item) {
                this.func_145779_a(dropItem, 1);
            }
        }
        if (this.func_70830_n() && dropItem != null) {
            numberOfTimes = this.field_70146_Z.nextInt(40) + 20;
            if (lootingModifier > 0) {
                numberOfTimes += this.field_70146_Z.nextInt(lootingModifier * 6 + 1);
            }
            for (item = 0; item < numberOfTimes; ++item) {
                this.func_145779_a(dropItem, 1);
            }
        }
    }
}

