/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.element;

import com.google.gson.JsonObject;
import net.minecraft.block.Block;
import net.minecraft.command.CommandGive;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.repository.BookRepository;

public class ItemStackData {
    public String itemList = null;
    public transient BookRepository source;
    public transient ResourceLocation itemListLocation = null;
    public transient String action;
    public String id = "";
    public byte amount = 1;
    public short damage = 0;
    public JsonObject nbt;

    public ItemStack[] getItems() {
        if (this.itemListLocation != null && this.source.resourceExists(this.itemListLocation)) {
            try {
                ItemsList itemsList = (ItemsList)BookLoader.GSON.fromJson(this.source.resourceToString(this.source.getResource(this.itemListLocation)), ItemsList.class);
                ItemStack[] items = new ItemStack[itemsList.items.length];
                for (int i = 0; i < itemsList.items.length; ++i) {
                    items[i] = itemsList.items[i].getItem();
                }
                this.action = itemsList.action;
                return items;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ItemStack[]{this.getItem()};
    }

    private ItemStack getItem() {
        Item item;
        boolean isMissingItem = false;
        try {
            item = CommandGive.getItemByText(null, (String)this.id);
        }
        catch (NumberInvalidException e) {
            item = Item.getItemFromBlock((Block)Blocks.BARRIER);
            isMissingItem = true;
        }
        if (item == null) {
            item = Item.getItemFromBlock((Block)Blocks.BARRIER);
            isMissingItem = true;
        }
        ItemStack itemStack = new ItemStack(item, (int)this.amount, (int)this.damage);
        if (this.nbt != null) {
            try {
                itemStack.setTagCompound(JsonToNBT.getTagFromJson((String)ItemStackData.filterJsonQuotes(this.nbt.toString())));
            }
            catch (NBTException nBTException) {
                // empty catch block
            }
        }
        if (isMissingItem) {
            NBTTagCompound display = itemStack.getSubCompound("display", true);
            display.setString("Name", "\u00a7rUnknown Item");
            NBTTagList lore = new NBTTagList();
            lore.appendTag((NBTBase)new NBTTagString("\u00a7r\u00a7eItem Name:"));
            lore.appendTag((NBTBase)new NBTTagString("\u00a7r\u00a7e" + this.id));
            display.setTag("Lore", (NBTBase)lore);
        }
        return itemStack;
    }

    public static ItemStackData getItemStackData(ItemStack stack) {
        return ItemStackData.getItemStackData(stack, false);
    }

    public static ItemStackData getItemStackData(ItemStack stack, boolean ignoreNbt) {
        ItemStackData data = new ItemStackData();
        data.id = ((ResourceLocation)Item.REGISTRY.getNameForObject((Object)stack.getItem())).toString();
        data.amount = (byte)stack.stackSize;
        data.damage = (short)stack.getItemDamage();
        if (!ignoreNbt && stack.getTagCompound() != null) {
            data.nbt = BookLoader.GSON.toJsonTree((Object)stack.getTagCompound(), NBTTagCompound.class).getAsJsonObject();
        }
        return data;
    }

    public static String filterJsonQuotes(String s) {
        return s.replaceAll("\"(\\w+)\"\\s*:", "$1: ");
    }

    public static class ItemLink {
        public ItemStackData item = new ItemStackData();
        public boolean damageSensitive = false;
        public String action = "";
    }

    private static class ItemsList {
        public ItemStackData[] items = new ItemStackData[0];
        public String action;

        private ItemsList() {
        }
    }
}

