/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.objectmapping;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Injector;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import ninja.leaping.configurate.objectmapping.GuiceObjectMapper;
import ninja.leaping.configurate.objectmapping.ObjectMapper;
import ninja.leaping.configurate.objectmapping.ObjectMapperFactory;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

@Singleton
public final class GuiceObjectMapperFactory
implements ObjectMapperFactory {
    private final LoadingCache<Class<?>, ObjectMapper<?>> cache = CacheBuilder.newBuilder().weakKeys().maximumSize(512L).build(new CacheLoader<Class<?>, ObjectMapper<?>>(){

        @Override
        public ObjectMapper<?> load(Class<?> key) throws Exception {
            return new GuiceObjectMapper(GuiceObjectMapperFactory.this.injector, key);
        }
    });
    private final Injector injector;

    @Inject
    protected GuiceObjectMapperFactory(Injector baseInjector) {
        this.injector = baseInjector;
    }

    @Override
    public <T> ObjectMapper<T> getMapper(Class<T> type) throws ObjectMappingException {
        Preconditions.checkNotNull(type, "type");
        try {
            return this.cache.get(type);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ObjectMappingException) {
                throw (ObjectMappingException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }
}

