/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.BookHelper;
import slimeknights.mantle.client.book.BookTransformer;
import slimeknights.mantle.client.book.action.StringActionProcessor;
import slimeknights.mantle.client.book.action.protocol.ProtocolGoToPage;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.ContentBlank;
import slimeknights.mantle.client.book.data.content.ContentBlockInteraction;
import slimeknights.mantle.client.book.data.content.ContentCrafting;
import slimeknights.mantle.client.book.data.content.ContentError;
import slimeknights.mantle.client.book.data.content.ContentImage;
import slimeknights.mantle.client.book.data.content.ContentImageText;
import slimeknights.mantle.client.book.data.content.ContentSmelting;
import slimeknights.mantle.client.book.data.content.ContentSmithing;
import slimeknights.mantle.client.book.data.content.ContentStructure;
import slimeknights.mantle.client.book.data.content.ContentText;
import slimeknights.mantle.client.book.data.content.ContentTextImage;
import slimeknights.mantle.client.book.data.content.ContentTextLeftImage;
import slimeknights.mantle.client.book.data.content.ContentTextRightImage;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.deserializer.HexStringDeserializer;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.network.NetworkWrapper;
import slimeknights.mantle.network.book.PacketUpdateSavedPage;

@SideOnly(value=Side.CLIENT)
public class BookLoader
implements IResourceManagerReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Integer.TYPE, (Object)new HexStringDeserializer()).create();
    private static final HashMap<String, Class<? extends PageContent>> typeToContentMap = new HashMap();
    private static final HashMap<String, BookData> books = new HashMap();
    private static final NetworkWrapper wrapper = new NetworkWrapper("mantle:books");

    public BookLoader() {
        ((IReloadableResourceManager)Minecraft.getMinecraft().getResourceManager()).registerReloadListener((IResourceManagerReloadListener)this);
        wrapper.registerPacketServer(PacketUpdateSavedPage.class);
        BookLoader.registerPageType("blank", ContentBlank.class);
        BookLoader.registerPageType("text", ContentText.class);
        BookLoader.registerPageType("image", ContentImage.class);
        BookLoader.registerPageType("image with text below", ContentImageText.class);
        BookLoader.registerPageType("text with image below", ContentTextImage.class);
        BookLoader.registerPageType("text with left image etch", ContentTextLeftImage.class);
        BookLoader.registerPageType("text with right image etch", ContentTextRightImage.class);
        BookLoader.registerPageType("crafting", ContentCrafting.class);
        BookLoader.registerPageType("smelting", ContentSmelting.class);
        BookLoader.registerPageType("smithing", ContentSmithing.class);
        BookLoader.registerPageType("block interaction", ContentBlockInteraction.class);
        BookLoader.registerPageType("structure", ContentStructure.class);
        StringActionProcessor.registerProtocol(new ProtocolGoToPage());
        StringActionProcessor.registerProtocol(new ProtocolGoToPage(true, "go-to-page-rtn"));
    }

    public static void registerPageType(String name, Class<? extends PageContent> clazz) {
        if (typeToContentMap.containsKey(name)) {
            throw new IllegalArgumentException("Page type " + name + " already in use.");
        }
        typeToContentMap.put(name, clazz);
    }

    public static Class<? extends PageContent> getPageType(String name) {
        return typeToContentMap.get(name);
    }

    public static BookData registerBook(String name, BookRepository ... repositories) {
        return BookLoader.registerBook(name, true, true, repositories);
    }

    public static BookData registerBook(String name, boolean appendIndex, boolean appendContentTable, BookRepository ... repositories) {
        BookData info = new BookData(repositories);
        books.put(name.contains(":") ? name : Loader.instance().activeModContainer().getModId() + ":" + name, info);
        if (appendIndex) {
            info.addTransformer(BookTransformer.IndexTranformer());
        }
        if (appendContentTable) {
            info.addTransformer(BookTransformer.contentTableTransformer());
        }
        return info;
    }

    public static BookData getBook(String name) {
        return null;
    }

    public static void updateSavedPage(EntityPlayer player, ItemStack item, String page) {
        if (player == null) {
            return;
        }
        if (player.getHeldItem(EnumHand.MAIN_HAND) == null) {
            return;
        }
        BookHelper.writeSavedPage(item, page);
        BookLoader.wrapper.network.sendToServer((IMessage)new PacketUpdateSavedPage(page));
    }

    public void onResourceManagerReload(@Nonnull IResourceManager resourceManager) {
        Mantle.logger.info("Started loading books...");
        long time = System.nanoTime();
        for (BookData book : books.values()) {
            try {
                book.load();
            }
            catch (Exception e) {
                book.sections.clear();
                SectionData section = new SectionData(true);
                section.name = "errorenous";
                PageData page = new PageData(true);
                page.name = "errorenous";
                page.content = new ContentError("Failed to load the book due to an unexpected error.", e);
                section.pages.add(page);
                book.sections.add(section);
                e.printStackTrace();
            }
        }
        Mantle.logger.info("Book loading completed in " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds.");
    }
}

