/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.gson;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.SimpleConfigurationNode;
import ninja.leaping.configurate.loader.AbstractConfigurationLoader;
import ninja.leaping.configurate.loader.CommentHandler;
import ninja.leaping.configurate.loader.CommentHandlers;

public class GsonConfigurationLoader
extends AbstractConfigurationLoader<ConfigurationNode> {
    private final boolean lenient;
    private final String indent;

    public static Builder builder() {
        return new Builder();
    }

    protected GsonConfigurationLoader(CharSource source, CharSink sink, int indent, boolean lenient, boolean preservesHeader) {
        super(source, sink, new CommentHandler[]{CommentHandlers.DOUBLE_SLASH, CommentHandlers.SLASH_BLOCK, CommentHandlers.HASH}, preservesHeader);
        this.lenient = lenient;
        this.indent = Strings.repeat(" ", indent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void loadInternal(ConfigurationNode node, BufferedReader reader) throws IOException {
        JsonReader parser;
        block13: {
            parser = new JsonReader(reader);
            Throwable throwable = null;
            try {
                parser.setLenient(this.lenient);
                this.parseValue(parser, node);
                if (parser == null) return;
                if (throwable == null) break block13;
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (parser == null) throw throwable4;
                    if (throwable == null) {
                        parser.close();
                        throw throwable4;
                    }
                    try {
                        parser.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        try {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            throw throwable4;
                        }
                    }
                }
            }
            try {
                parser.close();
                return;
            }
            catch (Throwable throwable2) {
                try {
                    throwable.addSuppressed(throwable2);
                    return;
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    return;
                }
            }
        }
        parser.close();
    }

    private void parseValue(JsonReader parser, ConfigurationNode node) throws IOException {
        JsonToken token = parser.peek();
        switch (token) {
            case BEGIN_OBJECT: {
                this.parseObject(parser, node);
                break;
            }
            case BEGIN_ARRAY: {
                this.parseArray(parser, node);
                break;
            }
            case NUMBER: {
                double nextDouble = parser.nextDouble();
                int nextInt = (int)nextDouble;
                if ((double)nextInt == nextDouble) {
                    node.setValue(nextInt);
                    break;
                }
                node.setValue(nextDouble);
                break;
            }
            case STRING: {
                node.setValue(parser.nextString());
                break;
            }
            case BOOLEAN: {
                node.setValue(parser.nextBoolean());
                break;
            }
            case NULL: 
            case NAME: {
                break;
            }
            default: {
                throw new IOException("Unsupported token type: " + (Object)((Object)token));
            }
        }
    }

    private void parseArray(JsonReader parser, ConfigurationNode node) throws IOException {
        JsonToken token;
        parser.beginArray();
        while ((token = parser.peek()) != null) {
            switch (token) {
                case END_ARRAY: {
                    parser.endArray();
                    return;
                }
            }
            this.parseValue(parser, node.getAppendedNode());
        }
        throw new JsonParseException("Reached end of stream with unclosed array at!");
    }

    private void parseObject(JsonReader parser, ConfigurationNode node) throws IOException {
        JsonToken token;
        parser.beginObject();
        block4: while ((token = parser.peek()) != null) {
            switch (token) {
                case END_OBJECT: 
                case END_DOCUMENT: {
                    parser.endObject();
                    return;
                }
                case NAME: {
                    this.parseValue(parser, node.getNode(parser.nextName()));
                    continue block4;
                }
            }
            throw new JsonParseException("Received improper object value " + (Object)((Object)token));
        }
        throw new JsonParseException("Reached end of stream with unclosed object!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveInternal(ConfigurationNode node, Writer writer) throws IOException {
        JsonWriter generator;
        block14: {
            if (!this.lenient && !node.hasMapChildren()) {
                throw new IOException("Non-lenient json generators must have children of map type");
            }
            generator = new JsonWriter(writer);
            Throwable throwable = null;
            try {
                generator.setIndent(this.indent);
                generator.setLenient(this.lenient);
                this.generateValue(generator, node);
                generator.flush();
                writer.write(LINE_SEPARATOR);
                if (generator == null) return;
                if (throwable == null) break block14;
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (generator == null) throw throwable4;
                    if (throwable == null) {
                        generator.close();
                        throw throwable4;
                    }
                    try {
                        generator.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        try {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            throw throwable4;
                        }
                    }
                }
            }
            try {
                generator.close();
                return;
            }
            catch (Throwable throwable2) {
                try {
                    throwable.addSuppressed(throwable2);
                    return;
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    return;
                }
            }
        }
        generator.close();
    }

    @Override
    public ConfigurationNode createEmptyNode(ConfigurationOptions options) {
        options = options.setAcceptedTypes(ImmutableSet.of(Map.class, List.class, Double.class, Float.class, Long.class, Integer.class, new Class[]{Boolean.class, String.class}));
        return SimpleConfigurationNode.root(options);
    }

    private void generateValue(JsonWriter generator, ConfigurationNode node) throws IOException {
        if (node.hasMapChildren()) {
            this.generateObject(generator, node);
        } else if (node.hasListChildren()) {
            this.generateArray(generator, node);
        } else {
            Object value = node.getValue();
            if (value instanceof Double) {
                generator.value((Double)value);
            } else if (value instanceof Float) {
                generator.value((Float)value);
            } else if (value instanceof Long) {
                generator.value((Long)value);
            } else if (value instanceof Integer) {
                generator.value((Integer)value);
            } else if (value instanceof Boolean) {
                generator.value((Boolean)value);
            } else if (!(value instanceof byte[])) {
                generator.value(value.toString());
            }
        }
    }

    private void generateObject(JsonWriter generator, ConfigurationNode node) throws IOException {
        if (!node.hasMapChildren()) {
            throw new IOException("Node passed to generateObject does not have map children!");
        }
        generator.beginObject();
        for (Map.Entry<Object, ? extends ConfigurationNode> ent : node.getChildrenMap().entrySet()) {
            generator.name(ent.getKey().toString());
            this.generateValue(generator, ent.getValue());
        }
        generator.endObject();
    }

    private void generateArray(JsonWriter generator, ConfigurationNode node) throws IOException {
        if (!node.hasListChildren()) {
            throw new IOException("Node passed to generateArray does not have list children!");
        }
        List<? extends ConfigurationNode> children = node.getChildrenList();
        generator.beginArray();
        for (ConfigurationNode configurationNode : children) {
            this.generateValue(generator, configurationNode);
        }
        generator.endArray();
    }

    public static class Builder
    extends AbstractConfigurationLoader.Builder<Builder> {
        private boolean lenient = true;
        private int indent = 2;

        public Builder setIndent(int indent) {
            this.indent = indent;
            return this;
        }

        public Builder setLenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        @Override
        public GsonConfigurationLoader build() {
            return new GsonConfigurationLoader(this.source, this.sink, this.indent, this.lenient, this.preserveHeader);
        }
    }
}

