/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.gui.book.element;

import java.util.Collection;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.book.action.StringActionProcessor;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.gui.book.TextDataRenderer;
import slimeknights.mantle.client.gui.book.element.SizedBookElement;

@SideOnly(value=Side.CLIENT)
public class ElementText
extends SizedBookElement {
    public TextData[] text;
    private boolean doAction = false;

    public ElementText(int x, int y, int width, int height, String text) {
        this(x, y, width, height, new TextData(text));
    }

    public ElementText(int x, int y, int width, int height, Collection<TextData> text) {
        this(x, y, width, height, text.toArray(new TextData[text.size()]));
    }

    public ElementText(int x, int y, int width, int height, TextData ... text) {
        super(x, y, width, height);
        this.text = text;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        String action = TextDataRenderer.drawText(this.x, this.y, this.width, this.height, this.text, mouseX, mouseY, fontRenderer);
        if (this.doAction) {
            this.doAction = false;
            StringActionProcessor.process(action, this.parent);
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.doAction = true;
        }
    }
}

