/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.gui.book.element;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.model.pipeline.LightUtil;
import org.lwjgl.opengl.GL11;
import slimeknights.mantle.client.book.data.element.BlockData;
import slimeknights.mantle.client.book.data.element.ItemStackData;
import slimeknights.mantle.client.gui.book.element.SizedBookElement;

public class ElementStructure
extends SizedBookElement {
    private BlockColors blockColors = Minecraft.getMinecraft().getBlockColors();
    private ItemColors itemColors = Minecraft.getMinecraft().getItemColors();
    private BlockAccess world;
    private float scale = 50.0f;
    private float xTranslate = 0.0f;
    private float yTranslate = 0.0f;
    private float w = 0.0f;
    private float h = 0.0f;
    private float rotX = -11.25f;
    private float rotY = 45.0f;
    private float rotZ = 0.0f;

    public ElementStructure(int x, int y, int width, int height, int[] size, BlockData[] structure) {
        super(x, y, width, height);
        this.world = new BlockAccess(size, structure);
        if (size.length == 3) {
            float f = this.scale = size[0] > size[1] ? (float)(width / size[0]) - 10.0f : (float)(height / size[1]) - 10.0f;
            if (this.scale * (float)size[0] > (float)width) {
                this.scale = (float)(width / size[0]) - 10.0f;
            }
            this.xTranslate = (float)(x + width / 2) - (float)size[0] * this.scale / 2.0f;
            this.yTranslate = (float)(y + height / 2) - (float)size[1] * this.scale / 2.0f;
            this.w = (float)size[0] * this.scale;
            this.h = (float)size[1] * this.scale;
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)this.xTranslate, (float)this.yTranslate, (float)500.0f);
        GlStateManager.cullFace((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
        GL11.glEnable((int)2960);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glDepthMask((boolean)false);
        GL11.glStencilFunc((int)512, (int)1, (int)255);
        GL11.glStencilOp((int)7681, (int)7680, (int)7680);
        GL11.glStencilMask((int)255);
        GL11.glClear((int)1024);
        GL11.glBegin((int)7);
        GL11.glVertex2i((int)0, (int)0);
        GL11.glVertex2i((int)0, (int)this.height);
        GL11.glVertex2i((int)this.width, (int)this.height);
        GL11.glVertex2i((int)this.width, (int)0);
        GL11.glEnd();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthMask((boolean)true);
        GL11.glStencilMask((int)0);
        GL11.glStencilFunc((int)514, (int)0, (int)255);
        GlStateManager.color((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glVertex2i((int)0, (int)0);
        GL11.glVertex2i((int)0, (int)this.height);
        GL11.glVertex2i((int)this.width, (int)this.height);
        GL11.glVertex2i((int)this.width, (int)0);
        GL11.glEnd();
        GlStateManager.translate((float)(this.w / 2.0f), (float)(this.h / 2.0f), (float)0.0f);
        GlStateManager.rotate((float)this.rotX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotate((float)this.rotY, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)this.rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translate((float)(-this.w / 2.0f), (float)(-this.h / 2.0f), (float)0.0f);
        for (int x = 0; x < this.world.getWidth(); ++x) {
            for (int y = 0; y < this.world.getHeight(); ++y) {
                for (int z = 0; z < this.world.getDepth(); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState state = this.world.getBlockState(pos);
                    IBakedModel model = this.mc.getBlockRendererDispatcher().getModelForState(state);
                    Block block = state.getBlock();
                    if (block == Blocks.AIR) continue;
                    GlStateManager.pushMatrix();
                    GlStateManager.enableDepth();
                    this.mc.renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
                    if (block == null) {
                        return;
                    }
                    int color = this.blockColors.colorMultiplier(state, (IBlockAccess)this.world, pos, 0);
                    float red = (float)(color >> 16 & 0xFF) / 255.0f;
                    float green = (float)(color >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(color & 0xFF) / 255.0f;
                    GlStateManager.color((float)red, (float)green, (float)blue);
                    GlStateManager.scale((float)this.scale, (float)this.scale, (float)this.scale);
                    GlStateManager.translate((float)x, (float)(this.world.getHeight() - y), (float)z);
                    BlockModelRenderer render = this.mc.getBlockRendererDispatcher().getBlockModelRenderer();
                    int i = this.blockColors.colorMultiplier(state, (IBlockAccess)this.world, pos, 0);
                    GlStateManager.rotate((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    if (EntityRenderer.anaglyphEnable) {
                        i = TextureUtil.anaglyphColor((int)i);
                    }
                    float r = (float)(i >> 16 & 0xFF) / 255.0f;
                    float g = (float)(i >> 8 & 0xFF) / 255.0f;
                    float b = (float)(i & 0xFF) / 255.0f;
                    render.renderModelBrightnessColor(model, (float)this.blockColors.colorMultiplier(state, (IBlockAccess)this.world, pos, 0), r, g, b);
                    GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.popMatrix();
                    this.renderEngine.getTexture(TextureMap.LOCATION_BLOCKS_TEXTURE).restoreLastBlurMipmap();
                }
            }
        }
        GlStateManager.disableLighting();
        GlStateManager.cullFace((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GL11.glDisable((int)2960);
        GlStateManager.popMatrix();
    }

    private void setupGuiTransform(int xPosition, int yPosition) {
        GlStateManager.translate((float)xPosition, (float)yPosition, (float)(100.0f + this.zLevel));
        GlStateManager.translate((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.scale((float)1.0f, (float)1.0f, (float)-1.0f);
        GlStateManager.scale((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.scale((float)40.0f, (float)40.0f, (float)40.0f);
        GlStateManager.rotate((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotate((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.enableLighting();
    }

    private void renderQuads(VertexBuffer renderer, List<BakedQuad> quads, int color, BlockPos pos) {
        boolean flag = color == -1;
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.hasTintIndex()) {
                Block block = this.world.getBlockState(pos).getBlock();
                k = this.blockColors.colorMultiplier(this.world.getBlockState(pos), (IBlockAccess)this.world, pos, 0);
                if (EntityRenderer.anaglyphEnable) {
                    k = TextureUtil.anaglyphColor((int)k);
                }
                k |= 0xFF000000;
            }
            LightUtil.renderQuadColor((VertexBuffer)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }

    private class BlockAccess
    implements IBlockAccess {
        private final int[][][] blocks;
        private final byte[][][] meta;
        private final int[] size;
        private HashMap<Integer[], TileEntity> tileEntityMap = new HashMap();

        public BlockAccess(int[] size, BlockData[] structure) {
            this.size = size;
            this.blocks = new int[size[0]][size[1]][size[2]];
            this.meta = new byte[size[0]][size[1]][size[2]];
            for (BlockData block : structure) {
                byte metadata;
                Block tile = Block.getBlockFromName((String)block.block);
                if (tile == null) continue;
                byte by = metadata = block.meta >= 0 && block.meta < 16 ? block.meta : (byte)0;
                if (block.pos == null || block.pos.length != 3 || block.endPos == null || block.endPos.length != 3) continue;
                for (int x = block.pos[0]; x <= block.endPos[0]; ++x) {
                    for (int y = block.pos[1]; y <= block.endPos[1]; ++y) {
                        for (int z = block.pos[2]; z <= block.endPos[2]; ++z) {
                            TileEntity te;
                            if (x >= size[0] || y >= size[1] || z >= size[2]) continue;
                            this.blocks[x][y][z] = Block.getIdFromBlock((Block)tile);
                            this.meta[x][y][z] = metadata;
                            TileEntity tileEntity = te = tile.hasTileEntity(tile.getStateFromMeta((int)metadata)) ? tile.createTileEntity((World)Minecraft.getMinecraft().theWorld, tile.getStateFromMeta((int)metadata)) : null;
                            if (te == null) continue;
                            te.setPos(new BlockPos(x, y, z));
                            this.tileEntityMap.put(new Integer[]{x, y, z}, te);
                            if (block.nbt == null) continue;
                            try {
                                te.readFromNBT(JsonToNBT.getTagFromJson((String)ItemStackData.filterJsonQuotes(block.nbt.toString())));
                                continue;
                            }
                            catch (NBTException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }

        public TileEntity getTileEntity(@Nonnull BlockPos pos) {
            if (!this.isValid(pos)) {
                return null;
            }
            return this.tileEntityMap.get(new Integer[]{pos.getX(), pos.getY(), pos.getZ()});
        }

        public int getCombinedLight(@Nonnull BlockPos pos, int lightValue) {
            return 15;
        }

        @Nonnull
        public IBlockState getBlockState(@Nonnull BlockPos pos) {
            if (!this.isValid(pos)) {
                return Blocks.AIR.getDefaultState();
            }
            Block block = Block.getBlockById((int)this.blocks[pos.getX()][pos.getY()][pos.getZ()]);
            if (block == null) {
                return Blocks.AIR.getDefaultState();
            }
            return block.getActualState(block.getStateFromMeta((int)this.meta[pos.getX()][pos.getY()][pos.getZ()]), (IBlockAccess)this, pos);
        }

        public boolean isAirBlock(@Nonnull BlockPos pos) {
            return !this.isValid(pos) || Block.getBlockById((int)this.blocks[pos.getX()][pos.getY()][pos.getZ()]) == Blocks.AIR;
        }

        @Nonnull
        public Biome getBiome(@Nonnull BlockPos blockPos) {
            return Biomes.JUNGLE;
        }

        public boolean extendedLevelsInChunkCache() {
            return false;
        }

        public int getStrongPower(@Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
            if (!this.isValid(pos)) {
                return 0;
            }
            IBlockState iblockstate = this.getBlockState(pos);
            return iblockstate.getBlock().getStrongPower(iblockstate, (IBlockAccess)this, pos, direction);
        }

        @Nonnull
        public WorldType getWorldType() {
            return WorldType.DEFAULT;
        }

        public boolean isSideSolid(@Nonnull BlockPos pos, @Nonnull EnumFacing side, boolean _default) {
            if (!this.isValid(pos)) {
                return _default;
            }
            return this.getBlockState(pos).getBlock().isSideSolid(this.getBlockState(pos), (IBlockAccess)this, pos, side);
        }

        public boolean isValid(BlockPos pos) {
            return pos != null && pos.getX() < this.size[0] && pos.getY() < this.size[1] && pos.getZ() < this.size[2] && pos.getX() >= 0 && pos.getY() >= 0 && pos.getZ() >= 0;
        }

        public int getWidth() {
            return this.size[0];
        }

        public int getHeight() {
            return this.size[1];
        }

        public int getDepth() {
            return this.size[2];
        }
    }
}

