/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.item;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlockSlab;
import slimeknights.mantle.item.ItemBlockMeta;

public class ItemBlockSlab<T extends Enum<T> & IStringSerializable>
extends ItemBlockMeta {
    public EnumBlockSlab<T> slab;

    public ItemBlockSlab(EnumBlockSlab<T> block) {
        super((Block)block);
        this.slab = block;
    }

    @Nonnull
    public EnumActionResult func_180614_a(ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (stack.field_77994_a != 0 && player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            if (this.tryPlace(player, stack, world, pos, facing)) {
                return EnumActionResult.SUCCESS;
            }
            if (this.tryPlace(player, stack, world, pos.func_177972_a(facing), null)) {
                return EnumActionResult.SUCCESS;
            }
            return super.func_180614_a(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_179222_a(World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, EntityPlayer player, @Nonnull ItemStack stack) {
        BlockPos oldPos = pos;
        Comparable<?> type = this.slab.func_185674_a(stack);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.slab) {
            boolean flag;
            boolean bl = flag = state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP;
            if ((side == EnumFacing.UP && !flag || side == EnumFacing.DOWN && flag) && type == state.func_177229_b(this.slab.prop) && this.slab.getFullBlock(state) != null) {
                return true;
            }
        }
        return (state = world.func_180495_p(pos = pos.func_177972_a(side))).func_177230_c() == this.slab && type == state.func_177229_b(this.slab.prop) || super.func_179222_a(world, oldPos, side, player, stack);
    }

    private boolean tryPlace(EntityPlayer player, ItemStack stack, World worldIn, BlockPos pos, EnumFacing facing) {
        IBlockState state = worldIn.func_180495_p(pos);
        Comparable<?> type = this.slab.func_185674_a(stack);
        if (state.func_177230_c() == this.slab) {
            IBlockState fullBlock;
            BlockSlab.EnumBlockHalf half = (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)BlockSlab.field_176554_a);
            if (type == state.func_177229_b(this.slab.prop) && (facing == null || facing == EnumFacing.UP && half == BlockSlab.EnumBlockHalf.BOTTOM || facing == EnumFacing.DOWN && half == BlockSlab.EnumBlockHalf.TOP) && (fullBlock = this.slab.getFullBlock(state)) != null) {
                AxisAlignedBB axisalignedbb = fullBlock.func_185890_d(worldIn, pos);
                if (axisalignedbb != Block.field_185506_k && worldIn.func_72855_b(axisalignedbb.func_186670_a(pos)) && worldIn.func_180501_a(pos, fullBlock, 11)) {
                    SoundType soundtype = fullBlock.func_177230_c().func_185467_w();
                    worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    --stack.field_77994_a;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemModels() {
        ItemBlockSlab item = this;
        ResourceLocation loc = GameData.getBlockRegistry().getNameForObject((IForgeRegistryEntry)this.field_150939_a);
        for (Enum o : this.mappingProperty.func_177700_c()) {
            int meta = this.field_150939_a.func_176201_c(this.field_150939_a.func_176223_P().func_177226_a(this.mappingProperty, (Comparable)((Object)o)));
            String name = this.mappingProperty.func_177702_a((Comparable)((Object)o));
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(loc, "half=bottom," + this.mappingProperty.func_177701_a() + "=" + name));
        }
    }
}

