/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;

public abstract class EnumBlockSlab<E extends Enum<E> & IStringSerializable>
extends BlockSlab {
    public final PropertyEnum<E> prop;
    private final E[] values;
    private static PropertyEnum<?> tmp;

    public EnumBlockSlab(Material material, PropertyEnum<E> prop, Class<E> clazz) {
        super(EnumBlockSlab.preInit(material, prop));
        this.prop = prop;
        this.values = (Enum[])clazz.getEnumConstants();
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)BlockSlab.HALF, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM));
        this.useNeighborBrightness = true;
    }

    private static Material preInit(Material material, PropertyEnum<?> property) {
        tmp = property;
        return material;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (E type : this.values) {
            list.add(new ItemStack((Block)this, 1, ((EnumBlock.IEnumMeta)type).getMeta()));
        }
    }

    @Nonnull
    protected BlockStateContainer createBlockState() {
        if (this.prop == null) {
            return new BlockStateContainer((Block)this, new IProperty[]{HALF, tmp});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{HALF, this.prop});
    }

    @Nonnull
    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(this.prop, this.fromMeta(meta & 7)).withProperty((IProperty)HALF, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
    }

    public int getMetaFromState(IBlockState state) {
        int i = 0;
        i |= ((EnumBlock.IEnumMeta)((Object)((Enum)((Object)state.getValue(this.prop))))).getMeta();
        if (state.getValue((IProperty)HALF) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    public int damageDropped(IBlockState state) {
        return ((EnumBlock.IEnumMeta)((Object)((Enum)((Object)state.getValue(this.prop))))).getMeta();
    }

    protected E fromMeta(int meta) {
        if (meta < 0 || meta >= this.values.length) {
            meta = 0;
        }
        return this.values[meta];
    }

    @Nonnull
    public IProperty<E> getVariantProperty() {
        return this.prop;
    }

    @Nonnull
    public Comparable<?> getTypeForItem(@Nonnull ItemStack stack) {
        return this.fromMeta(stack.getItemDamage() & 7);
    }

    @Nonnull
    public String getUnlocalizedName(int meta) {
        return super.getUnlocalizedName() + "." + ((IStringSerializable)this.fromMeta(meta & 7)).getName();
    }

    public abstract IBlockState getFullBlock(IBlockState var1);

    public boolean isDouble() {
        return false;
    }
}

