/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.item;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlockSlab;
import slimeknights.mantle.item.ItemBlockMeta;

public class ItemBlockSlab<T extends Enum<T> & IStringSerializable>
extends ItemBlockMeta {
    public EnumBlockSlab<T> slab;

    public ItemBlockSlab(EnumBlockSlab<T> block) {
        super((Block)block);
        this.slab = block;
    }

    @Nonnull
    public EnumActionResult onItemUse(ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (stack.stackSize != 0 && player.canPlayerEdit(pos.offset(facing), facing, stack)) {
            if (this.tryPlace(player, stack, world, pos, facing)) {
                return EnumActionResult.SUCCESS;
            }
            if (this.tryPlace(player, stack, world, pos.offset(facing), null)) {
                return EnumActionResult.SUCCESS;
            }
            return super.onItemUse(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canPlaceBlockOnSide(World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, EntityPlayer player, @Nonnull ItemStack stack) {
        BlockPos oldPos = pos;
        Comparable<?> type = this.slab.getTypeForItem(stack);
        IBlockState state = world.getBlockState(pos);
        if (state.getBlock() == this.slab) {
            boolean flag;
            boolean bl = flag = state.getValue((IProperty)BlockSlab.HALF) == BlockSlab.EnumBlockHalf.TOP;
            if ((side == EnumFacing.UP && !flag || side == EnumFacing.DOWN && flag) && type == state.getValue(this.slab.prop) && this.slab.getFullBlock(state) != null) {
                return true;
            }
        }
        return (state = world.getBlockState(pos = pos.offset(side))).getBlock() == this.slab && type == state.getValue(this.slab.prop) || super.canPlaceBlockOnSide(world, oldPos, side, player, stack);
    }

    private boolean tryPlace(EntityPlayer player, ItemStack stack, World worldIn, BlockPos pos, EnumFacing facing) {
        IBlockState state = worldIn.getBlockState(pos);
        Comparable<?> type = this.slab.getTypeForItem(stack);
        if (state.getBlock() == this.slab) {
            IBlockState fullBlock;
            BlockSlab.EnumBlockHalf half = (BlockSlab.EnumBlockHalf)state.getValue((IProperty)BlockSlab.HALF);
            if (type == state.getValue(this.slab.prop) && (facing == null || facing == EnumFacing.UP && half == BlockSlab.EnumBlockHalf.BOTTOM || facing == EnumFacing.DOWN && half == BlockSlab.EnumBlockHalf.TOP) && (fullBlock = this.slab.getFullBlock(state)) != null) {
                AxisAlignedBB axisalignedbb = fullBlock.getCollisionBoundingBox(worldIn, pos);
                if (axisalignedbb != Block.NULL_AABB && worldIn.checkNoEntityCollision(axisalignedbb.offset(pos)) && worldIn.setBlockState(pos, fullBlock, 11)) {
                    SoundType soundtype = fullBlock.getBlock().getSoundType();
                    worldIn.playSound(player, pos, soundtype.getPlaceSound(), SoundCategory.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                    --stack.stackSize;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemModels() {
        ItemBlockSlab item = this;
        ResourceLocation loc = GameData.getBlockRegistry().getNameForObject((IForgeRegistryEntry)this.block);
        for (Enum o : this.mappingProperty.getAllowedValues()) {
            int meta = this.block.getMetaFromState(this.block.getDefaultState().withProperty(this.mappingProperty, (Comparable)((Object)o)));
            String name = this.mappingProperty.getName((Comparable)((Object)o));
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(loc, "half=bottom," + this.mappingProperty.getName() + "=" + name));
        }
    }
}

