/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.config;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.config.AbstractConfig;
import slimeknights.mantle.config.AbstractConfigFile;
import slimeknights.mantle.config.AbstractConfigSyncPacket;
import slimeknights.mantle.network.NetworkWrapper;

class ExampleSync {
    static NetworkWrapper networkWrapper;
    static ExampleSync INSTANCE;
    @SideOnly(value=Side.CLIENT)
    private static boolean needsRestart;

    ExampleSync() {
    }

    static void setup() {
        networkWrapper = new NetworkWrapper("mantle:example");
        networkWrapper.registerPacketClient(ExampleSyncPacketImpl.class);
        INSTANCE = new ExampleSync();
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP && FMLCommonHandler.instance().getSide().isServer()) {
            ExampleSyncPacketImpl packet = new ExampleSyncPacketImpl();
            ExampleSync.networkWrapper.network.sendTo((IMessage)packet, (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void playerJoinedWorld(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        if (needsRestart) {
            player.sendMessage((ITextComponent)new TextComponentString("Configs synced with server. Configs require a restart"));
        } else {
            player.sendMessage((ITextComponent)new TextComponentString("Configs synced with server."));
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    static class ExampleSyncPacketImpl
    extends AbstractConfigSyncPacket {
        ExampleSyncPacketImpl() {
        }

        @Override
        protected AbstractConfig getConfig() {
            return ExampleConfig.INSTANCE;
        }

        @Override
        protected boolean sync() {
            if (super.sync()) {
                MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
                return true;
            }
            return false;
        }
    }

    static class ExampleConfigFile
    extends AbstractConfigFile {
        public ExampleConfigFile(File configFolder) {
            super(configFolder, "exampleconfigfile");
        }

        @Override
        public void insertDefaults() {
        }

        @Override
        protected int getConfigVersion() {
            return 1;
        }
    }

    static class ExampleConfig
    extends AbstractConfig {
        static ExampleConfig INSTANCE = new ExampleConfig();
        ExampleConfigFile exampleConfigFile;

        ExampleConfig() {
        }

        public void onPreInit(FMLPreInitializationEvent event) {
            this.exampleConfigFile = this.load(new ExampleConfigFile(event.getModConfigurationDirectory()), ExampleConfigFile.class);
            if (event.getSide().isServer()) {
                MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
            }
        }
    }
}

