/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.client.resources.IResource;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatisticsManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.IDataItem;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.content.ContentError;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.repository.BookRepository;

@SideOnly(value=Side.CLIENT)
public class SectionData
implements IDataItem {
    public String name = null;
    public ImageData icon = new ImageData();
    public String[] requirements = new String[0];
    public boolean hideWhenLocked = false;
    public String data = "";
    public transient int unnamedPageCounter = 0;
    public transient BookData parent;
    public transient BookRepository source;
    public transient ArrayList<PageData> pages = new ArrayList();

    public SectionData() {
        this(false);
    }

    public SectionData(boolean custom) {
        if (custom) {
            this.data = "no-load";
        }
    }

    public String translate(String string) {
        return this.parent.translate(string);
    }

    @Override
    public void load() {
        String data;
        IResource pagesInfo;
        if (this.name == null) {
            this.name = "section" + this.parent.unnamedSectionCounter++;
        }
        this.name = this.name.toLowerCase();
        if (!this.data.equals("no-load") && (pagesInfo = this.source.getResource(this.source.getResourceLocation(this.data))) != null && !(data = this.source.resourceToString(pagesInfo)).isEmpty()) {
            try {
                this.pages = new ArrayList<Object>(Arrays.asList((Object[])BookLoader.GSON.fromJson(data, PageData[].class)));
            }
            catch (Exception e) {
                this.pages = new ArrayList();
                PageData pdError = new PageData(true);
                pdError.name = "errorrenous";
                pdError.content = new ContentError("Failed to load section " + this.name + ".", e);
                this.pages.add(pdError);
            }
        }
        for (PageData page : this.pages) {
            page.parent = this;
            page.source = this.source;
            page.load();
        }
        this.icon.location = this.source.getResourceLocation(this.icon.file, true);
    }

    public void update(@Nullable StatisticsManager statisticsManager) {
    }

    public String getTitle() {
        String title = this.parent.strings.get(this.name);
        return title == null ? this.name : title;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public boolean isUnlocked(StatisticsManager statisticsManager) {
        if (statisticsManager == null || this.requirements == null || this.requirements.length == 0) {
            return true;
        }
        for (String achievement : this.requirements) {
            if (SectionData.requirementSatisfied(achievement, statisticsManager)) continue;
            return false;
        }
        return true;
    }

    public static boolean requirementSatisfied(String requirement, StatisticsManager writer) {
        if (writer == null) {
            return true;
        }
        Achievement achievement = SectionData.findAchievement(requirement);
        return achievement == null || writer.hasAchievementUnlocked(achievement);
    }

    public static Achievement findAchievement(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (Achievement achievement : AchievementList.ACHIEVEMENTS) {
            if (!achievement.statId.equals(name)) continue;
            return achievement;
        }
        return null;
    }
}

