/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.ingredients;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.plugins.jei.JEIInternalPlugin;
import mezz.jei.plugins.jei.ingredients.DebugIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.TextFormatting;

public class DebugIngredientRenderer
implements IIngredientRenderer<DebugIngredient> {
    @Override
    public void render(Minecraft minecraft, int xPosition, int yPosition, @Nullable DebugIngredient ingredient) {
        if (ingredient != null) {
            FontRenderer font = this.getFontRenderer(minecraft, ingredient);
            font.func_78276_b("JEI", xPosition, yPosition, Color.RED.getRGB());
            font.func_78276_b("#" + ingredient.getNumber(), xPosition, yPosition + 8, Color.RED.getRGB());
        }
    }

    @Override
    public List<String> getTooltip(Minecraft minecraft, DebugIngredient ingredient) {
        ArrayList<String> tooltip = new ArrayList<String>();
        IIngredientRegistry ingredientRegistry = JEIInternalPlugin.ingredientRegistry;
        if (ingredientRegistry != null) {
            IIngredientHelper<DebugIngredient> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredient);
            String displayName = ingredientHelper.getDisplayName(ingredient);
            tooltip.add(displayName);
            tooltip.add(TextFormatting.GRAY + "debug ingredient");
        }
        return tooltip;
    }

    @Override
    public FontRenderer getFontRenderer(Minecraft minecraft, DebugIngredient ingredient) {
        return minecraft.field_71466_p;
    }
}

