/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.ItemFilter;
import mezz.jei.api.IItemListOverlay;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.config.Config;
import mezz.jei.gui.GuiProperties;
import mezz.jei.gui.ItemListOverlayInternal;
import mezz.jei.util.Log;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;

public class ItemListOverlay
implements IItemListOverlay {
    private final ItemFilter itemFilter;
    private final List<IAdvancedGuiHandler<?>> advancedGuiHandlers;
    private final IIngredientRegistry ingredientRegistry;
    private final Set<ItemStack> highlightedStacks = new HashSet<ItemStack>();
    @Nullable
    private ItemListOverlayInternal internal;

    public ItemListOverlay(ItemFilter itemFilter, List<IAdvancedGuiHandler<?>> advancedGuiHandlers, IIngredientRegistry ingredientRegistry) {
        this.itemFilter = itemFilter;
        this.advancedGuiHandlers = advancedGuiHandlers;
        this.ingredientRegistry = ingredientRegistry;
    }

    @Nullable
    public ItemListOverlayInternal create(GuiScreen guiScreen) {
        int columns;
        GuiProperties guiProperties;
        this.close();
        if (Config.isOverlayEnabled() && (guiProperties = GuiProperties.create(guiScreen)) != null && (columns = ItemListOverlayInternal.getColumns(guiProperties)) >= 4) {
            this.internal = new ItemListOverlayInternal(this, this.ingredientRegistry, guiScreen, guiProperties);
            return this.internal;
        }
        return null;
    }

    @Nullable
    public ItemListOverlayInternal getInternal() {
        return this.internal;
    }

    @Override
    @Nullable
    public ItemStack getStackUnderMouse() {
        if (this.internal != null) {
            return this.internal.getStackUnderMouse();
        }
        return null;
    }

    @Override
    public void setFilterText(@Nullable String filterText) {
        if (filterText == null) {
            Log.error("null filterText", new NullPointerException());
            return;
        }
        Config.setFilterText(filterText);
        if (this.internal != null) {
            this.internal.setFilterText(filterText);
        }
    }

    public void rebuildItemFilter() {
        ItemFilter itemFilter = this.getItemFilter();
        itemFilter.rebuild();
        ItemListOverlayInternal.setToFirstPage();
        if (this.internal != null) {
            this.internal.updateLayout();
        }
    }

    @Override
    public String getFilterText() {
        return Config.getFilterText();
    }

    @Override
    public ImmutableList<ItemStack> getVisibleStacks() {
        if (this.internal == null) {
            return ImmutableList.of();
        }
        return this.internal.getVisibleStacks();
    }

    @Override
    public ImmutableList<ItemStack> getFilteredStacks() {
        return this.itemFilter.getItemStacks();
    }

    @Override
    public void highlightStacks(Collection<ItemStack> stacks) {
        this.highlightedStacks.clear();
        this.highlightedStacks.addAll(stacks);
    }

    public Set<ItemStack> getHighlightedStacks() {
        return this.highlightedStacks;
    }

    public ItemFilter getItemFilter() {
        return this.itemFilter;
    }

    public List<IAdvancedGuiHandler<?>> getAdvancedGuiHandlers() {
        return this.advancedGuiHandlers;
    }

    public boolean isOpen() {
        return this.internal != null;
    }

    public void close() {
        if (this.internal != null) {
            this.internal.close();
        }
        this.internal = null;
    }
}

