/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.gui.ingredients.GuiIngredientFast;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;

public class GuiIngredientFastList {
    private final List<GuiIngredientFast> renderAll = new ArrayList<GuiIngredientFast>();
    private final List<GuiIngredientFast> renderItems2d = new ArrayList<GuiIngredientFast>();
    private final List<GuiIngredientFast> renderItems3d = new ArrayList<GuiIngredientFast>();
    private final List<GuiIngredientFast> renderOther = new ArrayList<GuiIngredientFast>();
    private final IIngredientRegistry ingredientRegistry;

    public GuiIngredientFastList(IIngredientRegistry ingredientRegistry) {
        this.ingredientRegistry = ingredientRegistry;
    }

    public void clear() {
        this.renderAll.clear();
        this.renderItems2d.clear();
        this.renderItems3d.clear();
        this.renderOther.clear();
    }

    public int size() {
        return this.renderAll.size();
    }

    public void add(GuiIngredientFast guiItemStack) {
        this.renderAll.add(guiItemStack);
    }

    public List<GuiIngredientFast> getAllGuiIngredients() {
        return this.renderAll;
    }

    public void set(int i, List<IIngredientListElement> itemList) {
        this.renderItems2d.clear();
        this.renderItems3d.clear();
        this.renderOther.clear();
        for (GuiIngredientFast guiItemStack : this.renderAll) {
            if (i >= itemList.size()) {
                guiItemStack.clear();
            } else {
                Object ingredient = itemList.get(i).getIngredient();
                this.set(guiItemStack, ingredient);
            }
            ++i;
        }
    }

    private <V> void set(GuiIngredientFast guiItemStack, V ingredient) {
        guiItemStack.setIngredient(ingredient);
        if (ingredient instanceof ItemStack) {
            IBakedModel bakedModel;
            ItemStack stack = (ItemStack)ingredient;
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            try {
                bakedModel = renderItem.func_184393_a(stack, null, null);
            }
            catch (Throwable throwable) {
                IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
                String stackInfo = ingredientHelper.getErrorInfo(ingredient);
                Log.error("ItemStack crashed getting IBakedModel. " + stackInfo, throwable);
                guiItemStack.clear();
                return;
            }
            if (bakedModel == null) {
                IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
                String stackInfo = ingredientHelper.getErrorInfo(ingredient);
                Log.error("ItemStack returned null IBakedModel. " + stackInfo, new NullPointerException());
                guiItemStack.clear();
            } else if (bakedModel.func_188618_c()) {
                this.renderOther.add(guiItemStack);
            } else if (bakedModel.func_177556_c()) {
                this.renderItems3d.add(guiItemStack);
            } else {
                this.renderItems2d.add(guiItemStack);
            }
        } else {
            this.renderOther.add(guiItemStack);
        }
    }

    @Nullable
    public ClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        Object ingredient;
        GuiIngredientFast hovered = this.getHovered(mouseX, mouseY);
        if (hovered != null && (ingredient = hovered.getIngredient()) != null) {
            return new ClickedIngredient<Object>(ingredient);
        }
        return null;
    }

    @Nullable
    private GuiIngredientFast getHovered(int mouseX, int mouseY) {
        for (GuiIngredientFast guiItemStack : this.renderAll) {
            if (!guiItemStack.isMouseOver(mouseX, mouseY)) continue;
            return guiItemStack;
        }
        return null;
    }

    @Nullable
    public GuiIngredientFast render(Minecraft minecraft, boolean isMouseOver, int mouseX, int mouseY) {
        GuiIngredientFast hovered = null;
        if (isMouseOver) {
            hovered = this.getHovered(mouseX, mouseY);
        }
        RenderHelper.func_74520_c();
        RenderItem renderItem = minecraft.func_175599_af();
        TextureManager textureManager = minecraft.func_110434_K();
        renderItem.field_77023_b += 50.0f;
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179145_e();
        for (GuiIngredientFast guiItemStack : this.renderItems3d) {
            if (hovered == guiItemStack) continue;
            guiItemStack.renderItemAndEffectIntoGUI();
        }
        GlStateManager.func_179140_f();
        for (GuiIngredientFast guiItemStack : this.renderItems2d) {
            if (hovered == guiItemStack) continue;
            guiItemStack.renderItemAndEffectIntoGUI();
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        renderItem.field_77023_b -= 50.0f;
        for (GuiIngredientFast guiItemStack : this.renderItems3d) {
            if (hovered == guiItemStack) continue;
            guiItemStack.renderOverlay(minecraft);
        }
        for (GuiIngredientFast guiItemStack : this.renderItems2d) {
            if (hovered == guiItemStack) continue;
            guiItemStack.renderOverlay(minecraft);
        }
        for (GuiIngredientFast guiItemStack : this.renderOther) {
            if (hovered == guiItemStack) continue;
            guiItemStack.renderSlow();
        }
        RenderHelper.func_74518_a();
        return hovered;
    }
}

