/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import mezz.jei.JustEnoughItems;
import mezz.jei.config.SessionData;
import mezz.jei.network.packets.PacketGiveItemStack;
import mezz.jei.util.CommandUtilServer;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.StringUtils;

public final class CommandUtil {
    private CommandUtil() {
    }

    public static void giveStack(ItemStack itemStack, int mouseButton) {
        int amount;
        int n = amount = mouseButton == 0 ? itemStack.func_77976_d() : 1;
        if (SessionData.isJeiOnServer()) {
            ItemStack sendStack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)amount);
            PacketGiveItemStack packet = new PacketGiveItemStack(sendStack);
            JustEnoughItems.getProxy().sendPacketToServer(packet);
        } else {
            CommandUtil.giveStackVanilla(itemStack, amount);
        }
    }

    private static void giveStackVanilla(@Nullable ItemStack itemStack, int amount) {
        if (itemStack == null || itemStack.field_77994_a == 0) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            Log.error("Empty itemStack: {}", stackInfo, new IllegalArgumentException());
            return;
        }
        Item item = itemStack.func_77973_b();
        ResourceLocation itemResourceLocation = item.getRegistryName();
        Preconditions.checkNotNull((Object)itemResourceLocation, (Object)"itemStack.getItem().getRegistryName()");
        EntityPlayerSP sender = Minecraft.func_71410_x().field_71439_g;
        if (sender.func_70003_b(2, "give")) {
            CommandUtil.sendGiveAction(sender, itemStack, amount);
        } else if (sender.func_184812_l_()) {
            CommandUtil.sendCreativeInventoryActions(sender, itemStack, amount);
        } else {
            CommandUtil.sendGiveAction(sender, itemStack, amount);
        }
    }

    private static void sendGiveAction(EntityPlayerSP sender, ItemStack itemStack, int amount) {
        Object[] commandParameters = CommandUtilServer.getGiveCommandParameters((EntityPlayer)sender, itemStack, amount);
        String fullCommand = "/give " + StringUtils.join((Object[])commandParameters, (String)" ");
        CommandUtil.sendChatMessage(sender, fullCommand);
    }

    private static void sendChatMessage(EntityPlayerSP sender, String chatMessage) {
        if (chatMessage.length() <= 256) {
            sender.func_71165_d(chatMessage);
        } else {
            TextComponentTranslation errorMessage = new TextComponentTranslation("jei.chat.error.command.too.long", new Object[0]);
            errorMessage.func_150256_b().func_150238_a(TextFormatting.RED);
            sender.func_146105_b((ITextComponent)errorMessage);
            TextComponentString chatMessageComponent = new TextComponentString(chatMessage);
            chatMessageComponent.func_150256_b().func_150238_a(TextFormatting.RED);
            sender.func_146105_b((ITextComponent)chatMessageComponent);
        }
    }

    private static void sendCreativeInventoryActions(EntityPlayerSP sender, ItemStack stack, int amount) {
        for (int i = 0; i < sender.field_71071_by.field_70462_a.length && amount > 0; ++i) {
            ItemStack currentStack = sender.field_71071_by.field_70462_a[i];
            if (currentStack == null || currentStack.field_77994_a == 0) {
                ItemStack sendAllRemaining = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
                CommandUtil.sendSlotPacket(sendAllRemaining, i);
                amount = 0;
                continue;
            }
            if (!currentStack.func_77969_a(stack) || currentStack.func_77976_d() <= currentStack.field_77994_a) continue;
            int canAdd = Math.min(currentStack.func_77976_d() - currentStack.field_77994_a, amount);
            ItemStack fillRemainingSpace = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(canAdd + currentStack.field_77994_a));
            CommandUtil.sendSlotPacket(fillRemainingSpace, i);
            amount -= canAdd;
        }
        if (amount > 0) {
            ItemStack toDrop = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
            CommandUtil.sendSlotPacket(toDrop, -1);
        }
    }

    private static void sendSlotPacket(ItemStack stack, int mainInventorySlot) {
        if (mainInventorySlot < 9 && mainInventorySlot != -1) {
            mainInventorySlot += 36;
        }
        Minecraft.func_71410_x().field_71442_b.func_78761_a(stack, mainInventorySlot);
    }
}

