/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.gui.GuiProperties;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeArrowTab;
import mezz.jei.gui.recipes.RecipeCategoryTab;
import mezz.jei.gui.recipes.RecipeGuiTab;
import mezz.jei.input.IMouseHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;

public class RecipeGuiTabs
implements IMouseHandler {
    private final IRecipeGuiLogic recipeGuiLogic;
    private final List<RecipeGuiTab> tabs = new ArrayList<RecipeGuiTab>();
    private int pageCount = 1;
    private int pageNumber = 0;
    private int categoriesPerPage = 1;
    private int left;
    private int top;
    private int width;
    private int height;

    public RecipeGuiTabs(IRecipeGuiLogic recipeGuiLogic) {
        this.recipeGuiLogic = recipeGuiLogic;
    }

    public void updateLayout(GuiProperties guiProperties) {
        ImmutableList<IRecipeCategory> categories = this.recipeGuiLogic.getRecipeCategories();
        if (!categories.isEmpty()) {
            int totalWidth = 0;
            this.categoriesPerPage = 0;
            for (int i = 0; i < categories.size() && totalWidth + 24 <= guiProperties.getGuiXSize() - 4; ++i) {
                totalWidth += 24;
                ++this.categoriesPerPage;
            }
            this.width = totalWidth;
            this.height = 24;
            this.left = guiProperties.getGuiLeft() + 2;
            this.top = guiProperties.getGuiTop() - 24 + 3;
            this.pageCount = RecipeGuiTabs.getPageCount(categories.size(), this.categoriesPerPage);
            IRecipeCategory currentCategory = this.recipeGuiLogic.getSelectedRecipeCategory();
            int categoryIndex = categories.indexOf((Object)currentCategory);
            this.pageNumber = RecipeGuiTabs.getPageNumber(categoryIndex, this.pageCount, this.categoriesPerPage);
            this.createTabs();
        }
    }

    private static int getPageCount(int categoryCount, int categoriesPerPage) {
        int pageCount = 0;
        while (categoryCount > 0) {
            int availableCategories = categoriesPerPage;
            if (pageCount > 0) {
                --availableCategories;
            }
            if (categoryCount > availableCategories) {
                --availableCategories;
            }
            categoryCount -= availableCategories;
            ++pageCount;
        }
        return pageCount;
    }

    private static int getFirstCategoryIndex(int pageNumber, int pageCount, int categoriesPerPage) {
        int categoryIndex = 0;
        for (int i = 0; i < pageNumber; ++i) {
            int availableCategories = categoriesPerPage;
            if (i > 0) {
                --availableCategories;
            }
            if (i + 1 < pageCount) {
                --availableCategories;
            }
            categoryIndex += availableCategories;
        }
        return categoryIndex;
    }

    private static int getPageNumber(int categoryIndex, int pageCount, int categoriesPerPage) {
        int currentCategoryIndex = 0;
        for (int pageNumber = 0; pageNumber < pageCount; ++pageNumber) {
            int availableCategories = categoriesPerPage;
            if (pageNumber > 0) {
                --availableCategories;
            }
            if (pageNumber + 1 < pageCount) {
                --availableCategories;
            }
            if ((currentCategoryIndex += availableCategories) <= categoryIndex) continue;
            return pageNumber;
        }
        return 0;
    }

    private void createTabs() {
        int index;
        this.tabs.clear();
        ImmutableList<IRecipeCategory> categories = this.recipeGuiLogic.getRecipeCategories();
        boolean nextButton = false;
        boolean prevButton = false;
        int categoryCount = this.categoriesPerPage;
        if (categories.size() > categoryCount) {
            if (this.pageNumber + 1 < this.pageCount) {
                nextButton = true;
                --categoryCount;
            }
            if (this.pageNumber > 0) {
                prevButton = true;
                --categoryCount;
            }
        }
        int tabX = this.left;
        if (prevButton) {
            RecipeArrowTab tab = new RecipeArrowTab(this, false, tabX, this.top);
            this.tabs.add(tab);
            tabX += 24;
        }
        int startIndex = RecipeGuiTabs.getFirstCategoryIndex(this.pageNumber, this.pageCount, this.categoriesPerPage);
        for (int i = 0; i < categoryCount && (index = i + startIndex) < categories.size(); ++i) {
            IRecipeCategory category = (IRecipeCategory)categories.get(index);
            RecipeCategoryTab tab = new RecipeCategoryTab(this.recipeGuiLogic, category, tabX, this.top);
            this.tabs.add(tab);
            tabX += 24;
        }
        if (nextButton) {
            RecipeArrowTab tab = new RecipeArrowTab(this, true, tabX, this.top);
            this.tabs.add(tab);
        }
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY) {
        String tooltip;
        IRecipeCategory selectedCategory = this.recipeGuiLogic.getSelectedRecipeCategory();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RecipeGuiTab hovered = null;
        GlStateManager.func_179097_i();
        GlStateManager.func_179141_d();
        for (RecipeGuiTab tab : this.tabs) {
            boolean selected = tab.isSelected(selectedCategory);
            tab.draw(minecraft, selected, mouseX, mouseY);
            if (!tab.isMouseOver(mouseX, mouseY)) continue;
            hovered = tab;
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179126_j();
        if (hovered != null && (tooltip = hovered.getTooltip()) != null) {
            TooltipRenderer.drawHoveringText(minecraft, tooltip, mouseX, mouseY);
        }
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX > this.left && mouseX < this.left + this.width && mouseY > this.top && mouseY < this.top + this.height;
    }

    @Override
    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (RecipeGuiTab tab : this.tabs) {
                if (!tab.isMouseOver(mouseX, mouseY)) continue;
                tab.handleMouseClicked(mouseX, mouseY, mouseButton);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean handleMouseScrolled(int mouseX, int mouseY, int scrollDelta) {
        return false;
    }

    public void nextPage() {
        if (this.pageNumber + 1 < this.pageCount) {
            ++this.pageNumber;
            this.createTabs();
        }
    }

    public void prevPage() {
        if (this.pageNumber > 0) {
            --this.pageNumber;
            this.createTabs();
        }
    }
}

