/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network;

import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import mezz.jei.network.PacketIdServer;
import mezz.jei.network.packets.IPacketJeiHandler;
import mezz.jei.network.packets.PacketDeletePlayerItem;
import mezz.jei.network.packets.PacketGiveItemStack;
import mezz.jei.network.packets.PacketRecipeTransfer;
import mezz.jei.network.packets.PacketRequestCheatPermission;
import mezz.jei.network.packets.PacketSetHotbarItemStack;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ResourceLocation CHANNEL_ID = new ResourceLocation("jei", "channel");
    public final EnumMap<PacketIdServer, IPacketJeiHandler> serverHandlers = new EnumMap(PacketIdServer.class);

    public PacketHandler() {
        this.serverHandlers.put(PacketIdServer.RECIPE_TRANSFER, PacketRecipeTransfer::readPacketData);
        this.serverHandlers.put(PacketIdServer.DELETE_ITEM, PacketDeletePlayerItem::readPacketData);
        this.serverHandlers.put(PacketIdServer.GIVE_ITEM, PacketGiveItemStack::readPacketData);
        this.serverHandlers.put(PacketIdServer.SET_HOTBAR_ITEM, PacketSetHotbarItemStack::readPacketData);
        this.serverHandlers.put(PacketIdServer.CHEAT_PERMISSION_REQUEST, PacketRequestCheatPermission::readPacketData);
    }

    public void onPacket(NetworkEvent.ClientCustomPayloadEvent event) {
        PacketBuffer packetBuffer = new PacketBuffer((ByteBuf)event.getPayload());
        NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
        ServerPlayerEntity player = context.getSender();
        if (player == null) {
            LOGGER.error("Packet error, the sender player is missing for event: {}", (Object)event);
            return;
        }
        try {
            byte packetIdOrdinal = packetBuffer.readByte();
            PacketIdServer packetId = PacketIdServer.VALUES[packetIdOrdinal];
            IPacketJeiHandler packetHandler = this.serverHandlers.get(packetId);
            packetHandler.readPacketData(packetBuffer, (PlayerEntity)player);
        }
        catch (Throwable e) {
            LOGGER.error("Packet error for event: {}", (Object)event, (Object)e);
        }
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }
}

