/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.color;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.color.ColorThief;
import mezz.jei.util.ErrorUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ColorGetter
implements IColorHelper {
    public static final ColorGetter INSTANCE = new ColorGetter();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String[] defaultColors = new String[]{"White:EEEEEE", "LightBlue:7492cc", "Cyan:00EEEE", "Blue:2222dd", "LapisBlue:25418b", "Teal:008080", "Yellow:cacb58", "GoldenYellow:EED700", "Orange:d97634", "Pink:D1899D", "HotPink:FC0FC0", "Magenta:b24bbb", "Purple:813eb9", "JadedPurple:43324f", "EvilPurple:2e1649", "Lavender:B57EDC", "Indigo:480082", "Sand:dbd3a0", "Tan:bb9b63", "LightBrown:A0522D", "Brown:634b33", "DarkBrown:3a2d13", "LimeGreen:43b239", "SlimeGreen:83cb73", "Green:008000", "DarkGreen:224d22", "GrassGreen:548049", "Red:963430", "BrickRed:b0604b", "NetherBrick:2a1516", "Redstone:ce3e36", "Black:181515", "CharcoalGray:464646", "IronGray:646464", "Gray:808080", "Silver:C0C0C0"};

    private ColorGetter() {
    }

    public static String[] getColorDefaults() {
        return defaultColors;
    }

    public static List<Integer> getColors(ItemStack itemStack, int colorCount) {
        try {
            return ColorGetter.unsafeGetColors(itemStack, colorCount);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.debug("Failed to get color name for {}", (Object)itemStackInfo, (Object)e);
            return Collections.emptyList();
        }
    }

    private static List<Integer> unsafeGetColors(ItemStack itemStack, int colorCount) {
        Item item = itemStack.getItem();
        if (itemStack.isEmpty()) {
            return Collections.emptyList();
        }
        if (item instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)item;
            Block block = itemBlock.getBlock();
            if (block == null) {
                return Collections.emptyList();
            }
            return ColorGetter.getBlockColors(block, colorCount);
        }
        return ColorGetter.getItemColors(itemStack, colorCount);
    }

    private static List<Integer> getItemColors(ItemStack itemStack, int colorCount) {
        ItemColors itemColors = Minecraft.getInstance().getItemColors();
        int renderColor = itemColors.getColor(itemStack, 0);
        TextureAtlasSprite textureAtlasSprite = ColorGetter.getTextureAtlasSprite(itemStack);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return INSTANCE.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    private static List<Integer> getBlockColors(Block block, int colorCount) {
        BlockState blockState = block.defaultBlockState();
        BlockColors blockColors = Minecraft.getInstance().getBlockColors();
        int renderColor = blockColors.getColor(blockState, null, null, 0);
        TextureAtlasSprite textureAtlasSprite = ColorGetter.getTextureAtlasSprite(blockState);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return INSTANCE.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    @Override
    public List<Integer> getColors(TextureAtlasSprite textureAtlasSprite, int renderColor, int colorCount) {
        if (colorCount <= 0) {
            return Collections.emptyList();
        }
        NativeImage bufferedImage = ColorGetter.getNativeImage(textureAtlasSprite);
        if (bufferedImage == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> colors = new ArrayList<Integer>(colorCount);
        int[][] palette = ColorThief.getPalette(bufferedImage, colorCount, 2, false);
        if (palette != null) {
            for (int[] colorInt : palette) {
                int red = (int)((float)(colorInt[0] - 1) * (float)(renderColor >> 16 & 0xFF) / 255.0f);
                int green = (int)((float)(colorInt[1] - 1) * (float)(renderColor >> 8 & 0xFF) / 255.0f);
                int blue = (int)((float)(colorInt[2] - 1) * (float)(renderColor & 0xFF) / 255.0f);
                red = MathHelper.clamp((int)red, (int)0, (int)255);
                green = MathHelper.clamp((int)green, (int)0, (int)255);
                blue = MathHelper.clamp((int)blue, (int)0, (int)255);
                int color = 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                colors.add(color);
            }
        }
        return colors;
    }

    @Nullable
    private static NativeImage getNativeImage(TextureAtlasSprite textureAtlasSprite) {
        int iconWidth = textureAtlasSprite.getWidth();
        int iconHeight = textureAtlasSprite.getHeight();
        int frameCount = textureAtlasSprite.getFrameCount();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return null;
        }
        NativeImage[] frames = textureAtlasSprite.mainImage;
        return frames[0];
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(BlockState blockState) {
        Minecraft minecraft = Minecraft.getInstance();
        BlockRendererDispatcher blockRendererDispatcher = minecraft.getBlockRenderer();
        BlockModelShapes blockModelShapes = blockRendererDispatcher.getBlockModelShaper();
        TextureAtlasSprite textureAtlasSprite = blockModelShapes.getParticleIcon(blockState);
        if (textureAtlasSprite instanceof MissingTextureSprite) {
            return null;
        }
        return textureAtlasSprite;
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(ItemStack itemStack) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemModelMesher itemModelMesher = itemRenderer.getItemModelShaper();
        IBakedModel itemModel = itemModelMesher.getItemModel(itemStack);
        TextureAtlasSprite particleTexture = itemModel.getParticleIcon();
        if (particleTexture instanceof MissingTextureSprite) {
            return null;
        }
        return particleTexture;
    }
}

