/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.textures.Textures;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.click.MouseClickState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.text.StringTextComponent;

public class GuiIconButton
extends Button {
    private final IDrawable icon;
    private final MouseHandler mouseHandler;

    public GuiIconButton(IDrawable icon, Button.IPressable pressable) {
        super(0, 0, 0, 0, StringTextComponent.EMPTY, pressable);
        this.icon = icon;
        this.mouseHandler = new MouseHandler(this);
    }

    public void updateBounds(Rectangle2d area) {
        this.x = area.getX();
        this.y = area.getY();
        this.width = area.getWidth();
        this.height = area.getHeight();
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            Textures textures = Internal.getTextures();
            Minecraft minecraft = Minecraft.getInstance();
            DrawableNineSliceTexture texture = textures.getButtonForState(this.active, hovered);
            texture.draw(matrixStack, this.x, this.y, this.width, this.height);
            this.renderBg(matrixStack, minecraft, mouseX, mouseY);
            int color = 0xE0E0E0;
            if (this.packedFGColor != 0) {
                color = this.packedFGColor;
            } else if (!this.active) {
                color = 0xA0A0A0;
            } else if (hovered) {
                color = 0xFFFFA0;
            }
            if ((color & 0xFC000000) == 0) {
                color |= 0xFF000000;
            }
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float blue = (float)(color >> 8 & 0xFF) / 255.0f;
            float green = (float)(color & 0xFF) / 255.0f;
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            RenderSystem.color4f((float)red, (float)blue, (float)green, (float)alpha);
            double xOffset = (double)this.x + (double)(this.width - this.icon.getWidth()) / 2.0;
            double yOffset = (double)this.y + (double)(this.height - this.icon.getHeight()) / 2.0;
            matrixStack.pushPose();
            matrixStack.translate(xOffset, yOffset, 0.0);
            this.icon.draw(matrixStack);
            matrixStack.popPose();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public IMouseHandler getMouseHandler() {
        return this.mouseHandler;
    }

    private class MouseHandler
    implements IMouseHandler {
        private final GuiIconButton button;

        public MouseHandler(GuiIconButton button) {
            this.button = button;
        }

        @Override
        public IMouseHandler handleClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
            if (!(this.button.active && this.button.visible && GuiIconButton.this.isMouseOver(mouseX, mouseY))) {
                return null;
            }
            if (!this.button.isValidClickButton(mouseButton)) {
                return null;
            }
            boolean flag = this.button.clicked(mouseX, mouseY);
            if (!flag) {
                return null;
            }
            if (!clickState.isSimulate()) {
                this.button.playDownSound(Minecraft.getInstance().getSoundManager());
                this.button.onClick(mouseX, mouseY);
            }
            return this;
        }
    }
}

