/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.gui.textures.Textures;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.util.MathUtil;
import net.minecraft.client.renderer.Rectangle2d;

public class RecipeCatalysts
implements IShowsRecipeFocuses {
    private static final int ingredientSize = 16;
    private static final int ingredientBorderSize = 1;
    private static final int borderSize = 5;
    private static final int overlapSize = 6;
    private final DrawableNineSliceTexture backgroundTab;
    private final List<GuiIngredient<Object>> ingredients = new ArrayList<GuiIngredient<Object>>();
    private final DrawableNineSliceTexture slotBackground;
    private int left = 0;
    private int top = 0;
    private int width = 0;
    private int height = 0;

    public RecipeCatalysts() {
        Textures textures = Internal.getTextures();
        this.backgroundTab = textures.getCatalystTab();
        this.slotBackground = textures.getNineSliceSlot();
    }

    public boolean isEmpty() {
        return this.ingredients.isEmpty();
    }

    public int getWidth() {
        return this.width - 6;
    }

    public void updateLayout(List<Object> ingredients, RecipesGui recipesGui) {
        this.ingredients.clear();
        if (!ingredients.isEmpty()) {
            Rectangle2d recipeArea = recipesGui.getArea();
            int availableHeight = recipeArea.getHeight() - 8;
            int borderHeight = 12;
            int maxIngredientsPerColumn = (availableHeight - borderHeight) / 16;
            int columnCount = MathUtil.divideCeil(ingredients.size(), maxIngredientsPerColumn);
            maxIngredientsPerColumn = MathUtil.divideCeil(ingredients.size(), columnCount);
            this.width = 12 + columnCount * 16;
            this.height = 12 + maxIngredientsPerColumn * 16;
            this.top = recipeArea.getY();
            this.left = recipeArea.getX() - this.width + 6;
            for (int i = 0; i < ingredients.size(); ++i) {
                Object ingredientForSlot = ingredients.get(i);
                GuiIngredient<Object> guiIngredient = this.createGuiIngredient(ingredientForSlot, i, maxIngredientsPerColumn);
                this.ingredients.add(guiIngredient);
            }
        }
    }

    private <T> GuiIngredient<T> createGuiIngredient(T ingredient, int index, int maxIngredientsPerColumn) {
        IngredientManager ingredientManager = Internal.getIngredientManager();
        IIngredientRenderer<T> ingredientRenderer = ingredientManager.getIngredientRenderer(ingredient);
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredient);
        int column = index / maxIngredientsPerColumn;
        int row = index % maxIngredientsPerColumn;
        Rectangle2d rect = new Rectangle2d(this.left + 5 + column * 16 + 1, this.top + 5 + row * 16 + 1, 16, 16);
        GuiIngredient<T> guiIngredient = new GuiIngredient<T>(index, true, ingredientRenderer, ingredientHelper, rect, 0, 0, 0);
        guiIngredient.set(Collections.singletonList(ingredient), null);
        return guiIngredient;
    }

    @Nullable
    public GuiIngredient<?> draw(MatrixStack matrixStack, int mouseX, int mouseY) {
        int ingredientCount = this.ingredients.size();
        if (ingredientCount > 0) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableDepthTest();
            RenderSystem.enableAlphaTest();
            int slotWidth = this.width - 10;
            int slotHeight = this.height - 10;
            this.backgroundTab.draw(matrixStack, this.left, this.top, this.width, this.height);
            this.slotBackground.draw(matrixStack, this.left + 5, this.top + 5, slotWidth, slotHeight);
            RenderSystem.disableAlphaTest();
            RenderSystem.enableDepthTest();
            GuiIngredient<Object> hovered = null;
            for (GuiIngredient<Object> guiIngredient : this.ingredients) {
                if (guiIngredient.isMouseOver(0.0, 0.0, mouseX, mouseY)) {
                    hovered = guiIngredient;
                }
                guiIngredient.draw(matrixStack, 0, 0);
            }
            return hovered;
        }
        return null;
    }

    @Nullable
    private GuiIngredient<?> getHovered(double mouseX, double mouseY) {
        for (GuiIngredient<Object> guiIngredient : this.ingredients) {
            if (!guiIngredient.isMouseOver(0.0, 0.0, mouseX, mouseY)) continue;
            return guiIngredient;
        }
        return null;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        Object ingredientUnderMouse;
        GuiIngredient<?> hovered = this.getHovered(mouseX, mouseY);
        if (hovered != null && (ingredientUnderMouse = hovered.getDisplayedIngredient()) != null) {
            return ClickedIngredient.create(ingredientUnderMouse, hovered.getRect());
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }
}

