/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import javax.annotation.Nullable;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IShowsRecipeFocuses;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public class GuiContainerWrapper
implements IShowsRecipeFocuses {
    private final GuiScreenHelper guiScreenHelper;

    public GuiContainerWrapper(GuiScreenHelper guiScreenHelper) {
        this.guiScreenHelper = guiScreenHelper;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        ItemStack stack;
        Screen guiScreen = Minecraft.getInstance().screen;
        if (!(guiScreen instanceof ContainerScreen)) {
            return null;
        }
        ContainerScreen guiContainer = (ContainerScreen)guiScreen;
        Slot slotUnderMouse = guiContainer.getSlotUnderMouse();
        if (slotUnderMouse != null && !(stack = slotUnderMouse.getItem()).isEmpty()) {
            Rectangle2d slotArea = new Rectangle2d(slotUnderMouse.x, slotUnderMouse.y, 16, 16);
            return ClickedIngredient.create(stack, slotArea);
        }
        return this.guiScreenHelper.getPluginsIngredientUnderMouse(guiContainer, mouseX, mouseY);
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return false;
    }
}

