/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.Focus;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.recipes.RecipeManagerInternal;
import mezz.jei.util.ErrorUtil;
import net.minecraft.util.ResourceLocation;

public class RecipeManager
implements IRecipeManager {
    private final RecipeManagerInternal internal;
    private final IModIdHelper modIdHelper;

    public RecipeManager(RecipeManagerInternal internal, IModIdHelper modIdHelper) {
        this.internal = internal;
        this.modIdHelper = modIdHelper;
    }

    @Override
    public <V> IFocus<V> createFocus(IFocus.Mode mode, V ingredient) {
        return new Focus<V>(mode, ingredient);
    }

    @Override
    @Deprecated
    public <T> void addRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.internal.addRecipe(recipe, recipeCategoryUid);
    }

    @Override
    @Nullable
    public IRecipeCategory<?> getRecipeCategory(ResourceLocation recipeCategoryUid, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        return this.internal.getRecipeCategoriesStream((Collection<ResourceLocation>)ImmutableSet.of((Object)recipeCategoryUid), null, includeHidden).findFirst().orElse(null);
    }

    public <V> ImmutableList<IRecipeCategory<?>> getRecipeCategories(Collection<ResourceLocation> recipeCategoryUids, @Nullable IFocus<V> focus, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategoryUids, "recipeCategoryUids");
        Focus<V> internalFocus = Focus.checkNullable(focus);
        return (ImmutableList)this.internal.getRecipeCategoriesStream(recipeCategoryUids, internalFocus, includeHidden).collect(ImmutableList.toImmutableList());
    }

    public <V> ImmutableList<IRecipeCategory<?>> getRecipeCategories(@Nullable IFocus<V> focus, boolean includeHidden) {
        Focus<V> internalFocus = Focus.checkNullable(focus);
        return (ImmutableList)this.internal.getRecipeCategoriesStream(null, internalFocus, includeHidden).collect(ImmutableList.toImmutableList());
    }

    public <T, V> ImmutableList<T> getRecipes(IRecipeCategory<T> recipeCategory, @Nullable IFocus<V> focus, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        Focus<V> internalFocus = Focus.checkNullable(focus);
        return (ImmutableList)this.internal.getRecipesStream(recipeCategory, internalFocus, includeHidden).collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<Object> getRecipeCatalysts(IRecipeCategory<?> recipeCategory, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        return this.internal.getRecipeCatalysts(recipeCategory, includeHidden);
    }

    @Override
    public <T> IRecipeLayoutDrawable createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipe, IFocus<?> focus) {
        Focus<?> checkedFocus = Focus.check(focus);
        RecipeLayout<T> recipeLayout = RecipeLayout.create(-1, recipeCategory, recipe, checkedFocus, this.modIdHelper, 0, 0);
        Preconditions.checkNotNull(recipeLayout, (Object)"Recipe layout crashed during creation, see log.");
        return recipeLayout;
    }

    @Override
    public <T> void hideRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.internal.hideRecipe(recipe, recipeCategoryUid);
    }

    @Override
    public <T> void unhideRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.internal.unhideRecipe(recipe, recipeCategoryUid);
    }

    @Override
    public void hideRecipeCategory(ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.internal.hideRecipeCategory(recipeCategoryUid);
    }

    @Override
    public void unhideRecipeCategory(ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.internal.unhideRecipeCategory(recipeCategoryUid);
    }
}

