/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import java.util.Collection;
import java.util.Collections;
import mezz.jei.config.SearchMode;
import mezz.jei.ingredients.IIngredientListElementInfo;

public class PrefixInfo {
    public static final PrefixInfo NO_PREFIX = new PrefixInfo(() -> SearchMode.ENABLED, i -> Collections.singleton(i.getName()));
    private final IModeGetter modeGetter;
    private final IStringsGetter stringsGetter;

    public PrefixInfo(IModeGetter modeGetter, IStringsGetter stringsGetter) {
        this.modeGetter = modeGetter;
        this.stringsGetter = stringsGetter;
    }

    public SearchMode getMode() {
        return this.modeGetter.getMode();
    }

    public Collection<String> getStrings(IIngredientListElementInfo<?> element) {
        return this.stringsGetter.getStrings(element);
    }

    @FunctionalInterface
    public static interface IModeGetter {
        public SearchMode getMode();
    }

    @FunctionalInterface
    public static interface IStringsGetter {
        public Collection<String> getStrings(IIngredientListElementInfo<?> var1);
    }
}

