/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.brewing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.collect.IngredientSet;
import mezz.jei.util.ErrorUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrewingRecipeMaker {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<Class<?>> unhandledRecipeClasses = new HashSet();
    private final Set<IJeiBrewingRecipe> disabledRecipes = new HashSet<IJeiBrewingRecipe>();
    private final IIngredientManager ingredientManager;
    private final IVanillaRecipeFactory vanillaRecipeFactory;

    public static List<IJeiBrewingRecipe> getBrewingRecipes(IIngredientManager ingredientManager, IVanillaRecipeFactory vanillaRecipeFactory) {
        BrewingRecipeMaker brewingRecipeMaker = new BrewingRecipeMaker(ingredientManager, vanillaRecipeFactory);
        return brewingRecipeMaker.getBrewingRecipes();
    }

    private BrewingRecipeMaker(IIngredientManager ingredientManager, IVanillaRecipeFactory vanillaRecipeFactory) {
        this.ingredientManager = ingredientManager;
        this.vanillaRecipeFactory = vanillaRecipeFactory;
    }

    private List<IJeiBrewingRecipe> getBrewingRecipes() {
        this.unhandledRecipeClasses.clear();
        HashSet<IJeiBrewingRecipe> recipes = new HashSet<IJeiBrewingRecipe>();
        List brewingRecipes = BrewingRecipeRegistry.getRecipes();
        brewingRecipes.stream().filter(r -> r instanceof VanillaBrewingRecipe).map(r -> (VanillaBrewingRecipe)r).findFirst().ifPresent(vanillaBrewingRecipe -> this.addVanillaBrewingRecipes((Collection<IJeiBrewingRecipe>)recipes, (VanillaBrewingRecipe)vanillaBrewingRecipe));
        this.addModdedBrewingRecipes(brewingRecipes, recipes);
        ArrayList<IJeiBrewingRecipe> recipeList = new ArrayList<IJeiBrewingRecipe>(recipes);
        recipeList.sort(Comparator.comparingInt(IJeiBrewingRecipe::getBrewingSteps));
        return recipeList;
    }

    private void addVanillaBrewingRecipes(Collection<IJeiBrewingRecipe> recipes, VanillaBrewingRecipe vanillaBrewingRecipe) {
        boolean foundNewPotions;
        List<ItemStack> potionReagents = this.ingredientManager.getAllIngredients(VanillaTypes.ITEM).stream().filter(itemStack -> {
            try {
                return PotionBrewing.isIngredient((ItemStack)itemStack);
            }
            catch (LinkageError | RuntimeException e) {
                String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
                LOGGER.error("Failed to check if item is a potion reagent {}.", (Object)itemStackInfo, (Object)e);
                return false;
            }
        }).collect(Collectors.toList());
        ArrayList basePotions = new ArrayList();
        for (Ingredient potionItem : PotionBrewing.ALLOWED_CONTAINERS) {
            Collections.addAll(basePotions, potionItem.getItems());
        }
        IIngredientHelper<ItemStack> itemStackHelper = this.ingredientManager.getIngredientHelper(VanillaTypes.ITEM);
        IngredientSet<ItemStack> knownPotions = IngredientSet.create(itemStackHelper, UidContext.Ingredient);
        for (Potion potion : ForgeRegistries.POTION_TYPES.getValues()) {
            if (potion == Potions.EMPTY) continue;
            for (ItemStack input : basePotions) {
                ItemStack result = PotionUtils.setPotion((ItemStack)input.copy(), (Potion)potion);
                knownPotions.add(result);
            }
        }
        do {
            List<ItemStack> newPotions;
            foundNewPotions = !(newPotions = this.getNewPotions(knownPotions, potionReagents, recipes, vanillaBrewingRecipe)).isEmpty();
            knownPotions.addAll(newPotions);
        } while (foundNewPotions);
    }

    private List<ItemStack> getNewPotions(Collection<ItemStack> knownPotions, List<ItemStack> potionReagents, Collection<IJeiBrewingRecipe> recipes, VanillaBrewingRecipe vanillaBrewingRecipe) {
        ArrayList<ItemStack> newPotions = new ArrayList<ItemStack>();
        for (ItemStack potionInput : knownPotions) {
            for (ItemStack potionReagent : potionReagents) {
                IJeiBrewingRecipe recipe;
                ResourceLocation outputId;
                Potion potionInputType;
                ResourceLocation inputId;
                Potion potionOutputType;
                ItemStack potionOutput = vanillaBrewingRecipe.getOutput(potionInput.copy(), potionReagent);
                if (potionOutput.isEmpty() || potionInput.getItem() == potionOutput.getItem() && ((potionOutputType = PotionUtils.getPotion((ItemStack)potionOutput)) == Potions.WATER || Objects.equals(inputId = ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)(potionInputType = PotionUtils.getPotion((ItemStack)potionInput))), outputId = ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)potionOutputType))) || recipes.contains(recipe = this.vanillaRecipeFactory.createBrewingRecipe(Collections.singletonList(potionReagent), potionInput.copy(), potionOutput)) || this.disabledRecipes.contains(recipe)) continue;
                if (BrewingRecipeRegistry.hasOutput((ItemStack)potionInput, (ItemStack)potionReagent)) {
                    recipes.add(recipe);
                } else {
                    this.disabledRecipes.add(recipe);
                }
                newPotions.add(potionOutput);
            }
        }
        return newPotions;
    }

    private void addModdedBrewingRecipes(Collection<IBrewingRecipe> brewingRecipes, Collection<IJeiBrewingRecipe> recipes) {
        for (IBrewingRecipe iBrewingRecipe : brewingRecipes) {
            Class<?> recipeClass;
            if (iBrewingRecipe instanceof BrewingRecipe) {
                BrewingRecipe brewingRecipe = (BrewingRecipe)iBrewingRecipe;
                ItemStack[] ingredients = brewingRecipe.getIngredient().getItems();
                if (ingredients.length <= 0) continue;
                Ingredient inputIngredient = brewingRecipe.getInput();
                ItemStack output = brewingRecipe.getOutput();
                ItemStack[] inputs = inputIngredient.getItems();
                IJeiBrewingRecipe recipe = this.vanillaRecipeFactory.createBrewingRecipe(Arrays.asList(ingredients), Arrays.asList(inputs), output);
                recipes.add(recipe);
                continue;
            }
            if (iBrewingRecipe instanceof VanillaBrewingRecipe || this.unhandledRecipeClasses.contains(recipeClass = iBrewingRecipe.getClass())) continue;
            this.unhandledRecipeClasses.add(recipeClass);
            LOGGER.debug("Can't handle brewing recipe class: {}", recipeClass);
        }
    }
}

