/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.ingredients;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.plugins.jei.ingredients.DebugIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class DebugIngredientRenderer
implements IIngredientRenderer<DebugIngredient> {
    private final IIngredientHelper<DebugIngredient> ingredientHelper;

    public DebugIngredientRenderer(IIngredientHelper<DebugIngredient> ingredientHelper) {
        this.ingredientHelper = ingredientHelper;
    }

    @Override
    public void render(MatrixStack matrixStack, int xPosition, int yPosition, @Nullable DebugIngredient ingredient) {
        if (ingredient != null) {
            Minecraft minecraft = Minecraft.getInstance();
            FontRenderer font = this.getFontRenderer(minecraft, ingredient);
            font.draw(matrixStack, "JEI", (float)xPosition, (float)yPosition, -65536);
            font.draw(matrixStack, "#" + ingredient.getNumber(), (float)xPosition, (float)(yPosition + 8), -65536);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public List<ITextComponent> getTooltip(DebugIngredient ingredient, ITooltipFlag tooltipFlag) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        String displayName = this.ingredientHelper.getDisplayName(ingredient);
        tooltip.add((ITextComponent)new StringTextComponent(displayName));
        StringTextComponent debugIngredient = new StringTextComponent("debug ingredient");
        tooltip.add((ITextComponent)debugIngredient.withStyle(TextFormatting.GRAY));
        return tooltip;
    }
}

