/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ghost;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.gui.ghost.GhostIngredientDrag;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.math.vector.Vector2f;

public class GhostIngredientReturning<T> {
    private static final long DURATION_PER_SCREEN_WIDTH = 500L;
    private final IIngredientRenderer<T> ingredientRenderer;
    private final T ingredient;
    private final Vector2f start;
    private final Vector2f end;
    private final long startTime;
    private final long duration;

    @Nullable
    public static <T> GhostIngredientReturning<T> create(GhostIngredientDrag<T> ghostIngredientDrag, double mouseX, double mouseY) {
        Rectangle2d origin = ghostIngredientDrag.getOrigin();
        if (origin != null) {
            IIngredientRenderer<T> ingredientRenderer = ghostIngredientDrag.getIngredientRenderer();
            T ingredient = ghostIngredientDrag.getIngredient();
            Vector2f end = new Vector2f((float)origin.getX(), (float)origin.getY());
            Vector2f start = new Vector2f((float)mouseX - 8.0f, (float)mouseY - 8.0f);
            return new GhostIngredientReturning<T>(ingredientRenderer, ingredient, start, end);
        }
        return null;
    }

    private GhostIngredientReturning(IIngredientRenderer<T> ingredientRenderer, T ingredient, Vector2f start, Vector2f end) {
        this.ingredientRenderer = ingredientRenderer;
        this.ingredient = ingredient;
        this.start = start;
        this.end = end;
        this.startTime = System.currentTimeMillis();
        Screen currentScreen = Minecraft.getInstance().screen;
        if (currentScreen != null) {
            int width = currentScreen.width;
            float durationPerPixel = 500.0f / (float)width;
            float distance = (float)MathUtil.distance(start, end);
            this.duration = Math.round(durationPerPixel * distance);
        } else {
            this.duration = Math.round(250.0f);
        }
    }

    public void drawItem(Minecraft minecraft, MatrixStack matrixStack) {
        long time = System.currentTimeMillis();
        long elapsed = time - this.startTime;
        double percent = Math.min((double)elapsed / (double)this.duration, 1.0);
        double dx = this.end.x - this.start.x;
        double dy = this.end.y - this.start.y;
        double x = this.start.x + (float)Math.round(dx * percent);
        double y = this.start.y + (float)Math.round(dy * percent);
        ItemRenderer itemRenderer = minecraft.getItemRenderer();
        itemRenderer.blitOffset += 150.0f;
        this.ingredientRenderer.render(matrixStack, (int)x, (int)y, this.ingredient);
        itemRenderer.blitOffset -= 150.0f;
    }

    public boolean isComplete() {
        long time = System.currentTimeMillis();
        return this.startTime + this.duration < time;
    }
}

