/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.ArrayList;
import javax.annotation.Nullable;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketCheatPermission;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.GiveMode;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CommandUtilServer {
    private static final Logger LOGGER = LogManager.getLogger();

    private CommandUtilServer() {
    }

    public static String[] getGiveCommandParameters(PlayerEntity sender, ItemStack itemStack, int amount) {
        ITextComponent senderName = sender.getName();
        Item item = itemStack.getItem();
        ResourceLocation itemResourceLocation = item.getRegistryName();
        if (itemResourceLocation == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("item.getRegistryName() returned null for: " + stackInfo);
        }
        ArrayList<String> commandStrings = new ArrayList<String>();
        commandStrings.add(senderName.getString());
        String itemArgument = itemResourceLocation.toString();
        CompoundNBT tagCompound = itemStack.getTag();
        if (tagCompound != null) {
            itemArgument = itemArgument + tagCompound;
        }
        commandStrings.add(itemArgument);
        commandStrings.add(String.valueOf(amount));
        return commandStrings.toArray(new String[0]);
    }

    public static void writeChatMessage(PlayerEntity player, String translationKey, TextFormatting color) {
        TranslationTextComponent component = new TranslationTextComponent(translationKey);
        component.getStyle().applyFormat(color);
        player.sendMessage((ITextComponent)component, Util.NIL_UUID);
    }

    public static boolean hasPermission(PlayerEntity sender) {
        if (sender.isCreative()) {
            return true;
        }
        CommandNode<CommandSource> giveCommand = CommandUtilServer.getGiveCommand(sender);
        CommandSource commandSource = sender.createCommandSourceStack();
        if (giveCommand != null) {
            return giveCommand.canUse((Object)commandSource);
        }
        MinecraftServer minecraftServer = sender.getServer();
        if (minecraftServer == null) {
            return false;
        }
        int opPermissionLevel = minecraftServer.getOperatorUserPermissionLevel();
        return commandSource.hasPermission(opPermissionLevel);
    }

    public static void executeGive(ServerPlayerEntity sender, ItemStack itemStack, GiveMode giveMode) {
        if (CommandUtilServer.hasPermission((PlayerEntity)sender)) {
            if (giveMode == GiveMode.INVENTORY) {
                CommandUtilServer.giveToInventory((PlayerEntity)sender, itemStack);
            } else if (giveMode == GiveMode.MOUSE_PICKUP) {
                CommandUtilServer.mousePickupItemStack((PlayerEntity)sender, itemStack);
            }
        } else {
            Network.sendPacketToClient(new PacketCheatPermission(false), sender);
        }
    }

    public static void setHotbarSlot(ServerPlayerEntity sender, ItemStack itemStack, int hotbarSlot) {
        if (CommandUtilServer.hasPermission((PlayerEntity)sender)) {
            if (!PlayerInventory.isHotbarSlot((int)hotbarSlot)) {
                LOGGER.error("Tried to set slot that is not in the hotbar: {}", (Object)hotbarSlot);
                return;
            }
            ItemStack stackInSlot = sender.inventory.getItem(hotbarSlot);
            if (ItemStack.matches((ItemStack)stackInSlot, (ItemStack)itemStack)) {
                return;
            }
            ItemStack itemStackCopy = itemStack.copy();
            sender.inventory.setItem(hotbarSlot, itemStack);
            sender.level.playSound(null, sender.getX(), sender.getY(), sender.getZ(), SoundEvents.ITEM_PICKUP, SoundCategory.PLAYERS, 0.2f, ((sender.getRandom().nextFloat() - sender.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            sender.inventoryMenu.broadcastChanges();
            CommandUtilServer.notifyGive((PlayerEntity)sender, itemStackCopy);
        } else {
            Network.sendPacketToClient(new PacketCheatPermission(false), sender);
        }
    }

    public static void mousePickupItemStack(PlayerEntity sender, ItemStack itemStack) {
        int giveCount;
        ItemStack itemStackCopy = itemStack.copy();
        ItemStack existingStack = sender.inventory.getCarried();
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)existingStack, (ItemStack)itemStack)) {
            int newCount = Math.min(existingStack.getMaxStackSize(), existingStack.getCount() + itemStack.getCount());
            giveCount = newCount - existingStack.getCount();
            existingStack.setCount(newCount);
        } else {
            sender.inventory.setCarried(itemStack);
            giveCount = itemStack.getCount();
        }
        if (sender instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)sender;
            itemStackCopy.setCount(giveCount);
            CommandUtilServer.notifyGive((PlayerEntity)serverPlayerEntity, itemStackCopy);
            serverPlayerEntity.broadcastCarriedItem();
        }
    }

    private static void giveToInventory(PlayerEntity entityplayermp, ItemStack itemStack) {
        ItemStack itemStackCopy = itemStack.copy();
        boolean flag = entityplayermp.inventory.add(itemStack);
        if (flag && itemStack.isEmpty()) {
            itemStack.setCount(1);
            ItemEntity entityitem = entityplayermp.drop(itemStack, false);
            if (entityitem != null) {
                entityitem.makeFakeItem();
            }
            entityplayermp.level.playSound(null, entityplayermp.getX(), entityplayermp.getY(), entityplayermp.getZ(), SoundEvents.ITEM_PICKUP, SoundCategory.PLAYERS, 0.2f, ((entityplayermp.getRandom().nextFloat() - entityplayermp.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayermp.inventoryMenu.broadcastChanges();
        } else {
            ItemEntity entityitem = entityplayermp.drop(itemStack, false);
            if (entityitem != null) {
                entityitem.setNoPickUpDelay();
                entityitem.setOwner(entityplayermp.getUUID());
            }
        }
        CommandUtilServer.notifyGive(entityplayermp, itemStackCopy);
    }

    private static void notifyGive(PlayerEntity entityPlayerMP, ItemStack stack) {
        CommandSource commandSource = entityPlayerMP.createCommandSourceStack();
        int count = stack.getCount();
        ITextComponent stackTextComponent = stack.getDisplayName();
        ITextComponent displayName = entityPlayerMP.getDisplayName();
        TranslationTextComponent message = new TranslationTextComponent("commands.give.success.single", new Object[]{count, stackTextComponent, displayName});
        commandSource.sendSuccess((ITextComponent)message, true);
    }

    @Nullable
    private static CommandNode<CommandSource> getGiveCommand(PlayerEntity sender) {
        MinecraftServer minecraftServer = sender.getServer();
        if (minecraftServer == null) {
            return null;
        }
        Commands commandManager = minecraftServer.getCommands();
        CommandDispatcher dispatcher = commandManager.getDispatcher();
        RootCommandNode root = dispatcher.getRoot();
        return root.getChild("give");
    }
}

