/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.info;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.util.MathUtil;
import mezz.jei.util.StringUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class IngredientInfoRecipe<T> {
    private static final int lineSpacing = 2;
    private final List<ITextProperties> description;
    private final List<T> ingredients;
    private final IIngredientType<T> ingredientType;

    @Deprecated
    public static <T> List<IngredientInfoRecipe<T>> create(List<T> ingredients, IIngredientType<T> ingredientType, String ... descriptionKeys) {
        ITextComponent[] descriptionComponents = new ITextComponent[descriptionKeys.length];
        for (int i = 0; i < descriptionKeys.length; ++i) {
            String descriptionKey = descriptionKeys[i];
            descriptionComponents[i] = new TranslationTextComponent(descriptionKey);
        }
        return IngredientInfoRecipe.create(ingredients, ingredientType, descriptionComponents);
    }

    public static <T> List<IngredientInfoRecipe<T>> create(List<T> ingredients, IIngredientType<T> ingredientType, ITextComponent ... descriptionComponents) {
        ArrayList<IngredientInfoRecipe<T>> recipes = new ArrayList<IngredientInfoRecipe<T>>();
        List<ITextProperties> descriptionLines = StringUtil.expandNewlines(descriptionComponents);
        descriptionLines = StringUtil.splitLines(descriptionLines, 160);
        int lineCount = descriptionLines.size();
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71466_p.getClass();
        int maxLinesPerPage = 105 / (9 + 2);
        int pageCount = MathUtil.divideCeil(lineCount, maxLinesPerPage);
        for (int i = 0; i < pageCount; ++i) {
            int startLine = i * maxLinesPerPage;
            int endLine = Math.min((i + 1) * maxLinesPerPage, lineCount);
            List<ITextProperties> description = descriptionLines.subList(startLine, endLine);
            IngredientInfoRecipe<T> recipe = new IngredientInfoRecipe<T>(ingredients, ingredientType, description);
            recipes.add(recipe);
        }
        return recipes;
    }

    private IngredientInfoRecipe(List<T> ingredients, IIngredientType<T> ingredientType, List<ITextProperties> description) {
        this.description = description;
        this.ingredients = ingredients;
        this.ingredientType = ingredientType;
    }

    public List<ITextProperties> getDescription() {
        return this.description;
    }

    public IIngredientType<T> getIngredientType() {
        return this.ingredientType;
    }

    public List<T> getIngredients() {
        return this.ingredients;
    }
}

