/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import javax.annotation.Nullable;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.click.MouseClickState;
import mezz.jei.util.CommandUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;

public class CheatMouseHandler
implements IMouseHandler {
    private final IShowsRecipeFocuses showsRecipeFocuses;
    private final IWorldConfig worldConfig;
    private final IClientConfig clientConfig;

    public CheatMouseHandler(IShowsRecipeFocuses showsRecipeFocuses, IWorldConfig worldConfig, IClientConfig clientConfig) {
        this.showsRecipeFocuses = showsRecipeFocuses;
        this.worldConfig = worldConfig;
        this.clientConfig = clientConfig;
    }

    @Override
    @Nullable
    public IMouseHandler handleClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
        IClickedIngredient<?> clicked;
        if (!this.worldConfig.isCheatItemsEnabled()) {
            return null;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft == null) {
            return null;
        }
        Screen currentScreen = minecraft.screen;
        if (currentScreen == null || currentScreen instanceof RecipesGui) {
            return null;
        }
        InputMappings.Input input = InputMappings.Type.MOUSE.getOrCreate(mouseButton);
        if ((mouseButton == 0 || mouseButton == 1 || minecraft.options.keyPickItem.isActiveAndMatches(input)) && (clicked = this.showsRecipeFocuses.getIngredientUnderMouse(mouseX, mouseY)) != null) {
            ItemStack itemStack;
            if (!clickState.isSimulate() && !(itemStack = clicked.getCheatItemStack()).isEmpty()) {
                CommandUtil.giveStack(itemStack, input, this.clientConfig);
            }
            return this;
        }
        return null;
    }
}

