/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.Collection;
import net.minecraft.client.renderer.Rectangle2d;

public final class MathUtil {
    private MathUtil() {
    }

    public static int divideCeil(int numerator, int denominator) {
        return (int)Math.ceil((float)numerator / (float)denominator);
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static boolean intersects(Collection<Rectangle2d> areas, Rectangle2d comparisonArea) {
        for (Rectangle2d area : areas) {
            if (!MathUtil.intersects(area, comparisonArea)) continue;
            return true;
        }
        return false;
    }

    public static boolean intersects(Rectangle2d rect1, Rectangle2d rect2) {
        if (rect1.func_199316_c() <= 0 || rect1.func_199317_d() <= 0) {
            return false;
        }
        return rect2.func_199318_a() + rect2.func_199316_c() > rect1.func_199318_a() && rect2.func_199319_b() + rect2.func_199317_d() > rect1.func_199319_b() && rect2.func_199318_a() < rect1.func_199318_a() + rect1.func_199316_c() && rect2.func_199319_b() < rect1.func_199319_b() + rect1.func_199317_d();
    }

    public static Rectangle2d moveDownToAvoidIntersection(Collection<Rectangle2d> areas, Rectangle2d comparisonArea) {
        for (Rectangle2d area : areas) {
            if (!MathUtil.intersects(area, comparisonArea)) continue;
            Rectangle2d movedDown = new Rectangle2d(comparisonArea.func_199318_a(), area.func_199319_b() + area.func_199317_d(), comparisonArea.func_199316_c(), comparisonArea.func_199317_d());
            return MathUtil.moveDownToAvoidIntersection(areas, movedDown);
        }
        return comparisonArea;
    }

    public static boolean contains(Collection<Rectangle2d> areas, double x, double y) {
        for (Rectangle2d guiArea : areas) {
            if (!MathUtil.contains(guiArea, x, y)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Rectangle2d rect, double x, double y) {
        return x >= (double)rect.func_199318_a() && y >= (double)rect.func_199319_b() && x < (double)(rect.func_199318_a() + rect.func_199316_c()) && y < (double)(rect.func_199319_b() + rect.func_199317_d());
    }

    public static Rectangle2d union(Rectangle2d rect1, Rectangle2d rect2) {
        long tx2 = rect1.func_199316_c();
        long ty2 = rect1.func_199317_d();
        long rx2 = rect2.func_199316_c();
        long ry2 = rect2.func_199317_d();
        int tx1 = rect1.func_199318_a();
        int ty1 = rect1.func_199319_b();
        tx2 += (long)tx1;
        ty2 += (long)ty1;
        int rx1 = rect2.func_199318_a();
        int ry1 = rect2.func_199319_b();
        rx2 += (long)rx1;
        ry2 += (long)ry1;
        if (tx1 > rx1) {
            tx1 = rx1;
        }
        if (ty1 > ry1) {
            ty1 = ry1;
        }
        if (tx2 < rx2) {
            tx2 = rx2;
        }
        if (ty2 < ry2) {
            ty2 = ry2;
        }
        tx2 -= (long)tx1;
        ty2 -= (long)ty1;
        tx2 = Math.min(tx2, Integer.MAX_VALUE);
        ty2 = Math.min(ty2, Integer.MAX_VALUE);
        return new Rectangle2d(tx1, ty1, (int)tx2, (int)ty2);
    }
}

