/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.color.ColorGetter;
import mezz.jei.color.ColorNamer;
import mezz.jei.config.ConfigValues;
import mezz.jei.config.LocalizedConfiguration;
import mezz.jei.config.forge.Property;
import mezz.jei.util.GiveMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private static ClientConfig instance;
    private static final String configKeyPrefix = "config.jei";
    public static final String CATEGORY_ADVANCED = "advanced";
    public static final String CATEGORY_SEARCH_COLORS = "searchColors";
    public static final int smallestNumColumns = 4;
    public static final int largestNumColumns = 100;
    public static final int minRecipeGuiHeight = 175;
    public static final int maxRecipeGuiHeight = 5000;
    private final LocalizedConfiguration config;
    private final LocalizedConfiguration searchColorsConfig;
    private final ConfigValues defaultValues = new ConfigValues();
    private final ConfigValues values = new ConfigValues();

    @Deprecated
    public static ClientConfig getInstance() {
        Preconditions.checkNotNull((Object)instance);
        return instance;
    }

    public ClientConfig(File jeiConfigurationDir) {
        instance = this;
        File configFile = new File(jeiConfigurationDir, "jei.cfg");
        File searchColorsConfigFile = new File(jeiConfigurationDir, "searchColors.cfg");
        this.config = new LocalizedConfiguration(configKeyPrefix, configFile, "0.4.0");
        this.searchColorsConfig = new LocalizedConfiguration(configKeyPrefix, searchColorsConfigFile, "0.1.0");
    }

    public boolean isDebugModeEnabled() {
        return this.values.debugModeEnabled;
    }

    public boolean isCenterSearchBarEnabled() {
        return this.values.centerSearchBarEnabled;
    }

    public GiveMode getGiveMode() {
        return this.values.giveMode;
    }

    public int getMaxColumns() {
        return this.values.maxColumns;
    }

    public int getMaxRecipeGuiHeight() {
        return this.values.maxRecipeGuiHeight;
    }

    public LocalizedConfiguration getConfig() {
        return this.config;
    }

    public void onPreInit() {
        this.syncConfig();
        this.syncSearchColorsConfig();
    }

    public boolean syncAllConfig() {
        boolean needsReload = false;
        if (this.syncConfig()) {
            needsReload = true;
        }
        if (this.syncSearchColorsConfig()) {
            needsReload = true;
        }
        return needsReload;
    }

    private boolean syncConfig() {
        boolean needsReload = false;
        this.config.addCategory(CATEGORY_ADVANCED);
        this.values.centerSearchBarEnabled = this.config.getBoolean(CATEGORY_ADVANCED, "centerSearchBarEnabled", this.defaultValues.centerSearchBarEnabled);
        this.values.giveMode = (GiveMode)this.config.getEnum("giveMode", CATEGORY_ADVANCED, this.defaultValues.giveMode, GiveMode.values());
        this.values.maxColumns = this.config.getInt("maxColumns", CATEGORY_ADVANCED, this.defaultValues.maxColumns, 4, 100);
        this.values.maxRecipeGuiHeight = this.config.getInt("maxRecipeGuiHeight", CATEGORY_ADVANCED, this.defaultValues.maxRecipeGuiHeight, 175, 5000);
        Property property = this.config.get(CATEGORY_ADVANCED, "debugModeEnabled", this.defaultValues.debugModeEnabled);
        property.setShowInGui(false);
        this.values.debugModeEnabled = property.getBoolean();
        boolean configChanged = this.config.hasChanged();
        if (configChanged) {
            // empty if block
        }
        return needsReload;
    }

    private boolean syncSearchColorsConfig() {
        this.searchColorsConfig.addCategory(CATEGORY_SEARCH_COLORS);
        String[] searchColorDefaults = ColorGetter.getColorDefaults();
        String[] searchColors = this.searchColorsConfig.getStringList(CATEGORY_SEARCH_COLORS, CATEGORY_SEARCH_COLORS, searchColorDefaults);
        ImmutableMap.Builder searchColorsMapBuilder = ImmutableMap.builder();
        for (String entry : searchColors) {
            String[] values = entry.split(":");
            if (values.length != 2) {
                LOGGER.error("Invalid format for searchColor entry: {}", (Object)entry);
                continue;
            }
            try {
                String name = values[0];
                Integer colorValue = Integer.decode("0x" + values[1]);
                searchColorsMapBuilder.put((Object)colorValue, (Object)name);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Invalid number format for searchColor entry: {}", (Object)entry, (Object)e);
            }
        }
        ColorNamer colorNamer = new ColorNamer((ImmutableMap<Integer, String>)searchColorsMapBuilder.build());
        Internal.setColorNamer(colorNamer);
        boolean configChanged = this.searchColorsConfig.hasChanged();
        if (configChanged) {
            // empty if block
        }
        return configChanged;
    }
}

