/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.config.SearchMode;
import mezz.jei.events.EventBusHelper;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientListElementInfo;
import mezz.jei.ingredients.PrefixedSearchTree;
import mezz.jei.suffixtree.GeneralizedSuffixTree;
import net.minecraft.client.Minecraft;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class IngredientFilterBackgroundBuilder {
    private final Char2ObjectMap<PrefixedSearchTree> prefixedSearchTrees;
    private final NonNullList<IIngredientListElement> elementList;
    private final IIngredientManager ingredientManager;
    private final IModIdHelper modIdHelper;
    private final Consumer<TickEvent.ClientTickEvent> onTickHandler;

    public IngredientFilterBackgroundBuilder(Char2ObjectMap<PrefixedSearchTree> prefixedSearchTrees, NonNullList<IIngredientListElement> elementList, IIngredientManager ingredientManager, IModIdHelper modIdHelper) {
        this.prefixedSearchTrees = prefixedSearchTrees;
        this.elementList = elementList;
        this.ingredientManager = ingredientManager;
        this.modIdHelper = modIdHelper;
        this.onTickHandler = this::onClientTick;
    }

    public void start() {
        boolean finished = this.run(10000);
        if (!finished) {
            EventBusHelper.addListener(TickEvent.ClientTickEvent.class, this.onTickHandler);
        }
    }

    private void onClientTick(TickEvent.ClientTickEvent event) {
        boolean finished;
        if (event.side == LogicalSide.CLIENT && Minecraft.func_71410_x().field_71439_g != null && !(finished = this.run(20))) {
            return;
        }
        EventBusHelper.removeListener(this.onTickHandler);
    }

    private boolean run(int timeoutMs) {
        long startTime = System.currentTimeMillis();
        ArrayList<PrefixedSearchTree> activeTrees = new ArrayList<PrefixedSearchTree>();
        int startIndex = Integer.MAX_VALUE;
        for (PrefixedSearchTree prefixedTree : this.prefixedSearchTrees.values()) {
            SearchMode mode = prefixedTree.getMode();
            if (mode == SearchMode.DISABLED) continue;
            GeneralizedSuffixTree tree = prefixedTree.getTree();
            int nextFreeIndex = tree.getHighestIndex() + 1;
            startIndex = Math.min(nextFreeIndex, startIndex);
            if (nextFreeIndex >= this.elementList.size()) continue;
            activeTrees.add(prefixedTree);
        }
        if (activeTrees.isEmpty()) {
            return true;
        }
        for (int i = startIndex; i < this.elementList.size(); ++i) {
            IIngredientListElement element = (IIngredientListElement)this.elementList.get(i);
            IngredientListElementInfo info = IngredientListElementInfo.create(element, this.ingredientManager, this.modIdHelper);
            if (info == null) continue;
            for (PrefixedSearchTree prefixedTree : activeTrees) {
                GeneralizedSuffixTree tree = prefixedTree.getTree();
                int nextFreeIndex = tree.getHighestIndex() + 1;
                if (nextFreeIndex < i) continue;
                PrefixedSearchTree.IStringsGetter stringsGetter = prefixedTree.getStringsGetter();
                Collection<String> strings = stringsGetter.getStrings(info);
                if (strings.isEmpty()) {
                    tree.put("", i);
                    continue;
                }
                for (String string : strings) {
                    tree.put(string, i);
                }
            }
            if (System.currentTimeMillis() - startTime < (long)timeoutMs) continue;
            return false;
        }
        return true;
    }
}

