/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import javax.annotation.Nullable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.recipes.IOnClickHandler;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.recipes.RecipeTransferManager;
import mezz.jei.transfer.RecipeTransferErrorInternal;
import mezz.jei.transfer.RecipeTransferUtil;
import mezz.jei.util.Translator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;

public class RecipeTransferButton
extends GuiIconButtonSmall {
    private final RecipeLayout recipeLayout;
    @Nullable
    private IRecipeTransferError recipeTransferError;
    @Nullable
    private IOnClickHandler onClickHandler;

    public RecipeTransferButton(int id, int xPos, int yPos, int width, int height, IDrawable icon, RecipeLayout recipeLayout) {
        super(id, xPos, yPos, width, height, icon);
        this.recipeLayout = recipeLayout;
    }

    public void init(RecipeTransferManager recipeTransferManager, @Nullable Container container, EntityPlayer player) {
        this.recipeTransferError = container != null ? RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, container, this.recipeLayout, player) : RecipeTransferErrorInternal.INSTANCE;
        if (this.recipeTransferError == null) {
            this.field_146124_l = true;
            this.field_146125_m = true;
        } else {
            this.field_146124_l = false;
            IRecipeTransferError.Type type = this.recipeTransferError.getType();
            this.field_146125_m = type == IRecipeTransferError.Type.USER_FACING;
        }
    }

    public void drawToolTip(int mouseX, int mouseY) {
        if (this.field_146123_n && this.field_146125_m) {
            if (this.recipeTransferError != null) {
                this.recipeTransferError.showError(mouseX, mouseY, this.recipeLayout, this.recipeLayout.getPosX(), this.recipeLayout.getPosY());
            } else {
                String tooltipTransfer = Translator.translateToLocal("jei.tooltip.transfer");
                TooltipRenderer.drawHoveringText(tooltipTransfer, mouseX, mouseY);
            }
        }
    }

    public void setOnClickHandler(IOnClickHandler onClickHandler) {
        this.onClickHandler = onClickHandler;
    }

    public void func_194829_a(double mouseX, double mouseY) {
        if (this.onClickHandler != null) {
            this.onClickHandler.onClick(mouseX, mouseY);
        }
    }
}

