/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.color;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.color.ColorThief;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.MathUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ColorGetter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String[] defaultColors = new String[]{"White:EEEEEE", "LightBlue:7492cc", "Cyan:00EEEE", "Blue:2222dd", "LapisBlue:25418b", "Teal:008080", "Yellow:cacb58", "GoldenYellow:EED700", "Orange:d97634", "Pink:D1899D", "HotPink:FC0FC0", "Magenta:b24bbb", "Purple:813eb9", "JadedPurple:43324f", "EvilPurple:2e1649", "Lavender:B57EDC", "Indigo:480082", "Sand:dbd3a0", "Tan:bb9b63", "LightBrown:A0522D", "Brown:634b33", "DarkBrown:3a2d13", "LimeGreen:43b239", "SlimeGreen:83cb73", "Green:008000", "DarkGreen:224d22", "GrassGreen:548049", "Red:963430", "BrickRed:b0604b", "NetherBrick:2a1516", "Redstone:ce3e36", "Black:181515", "CharcoalGray:464646", "IronGray:646464", "Gray:808080", "Silver:C0C0C0"};

    private ColorGetter() {
    }

    public static String[] getColorDefaults() {
        return defaultColors;
    }

    public static List<Integer> getColors(ItemStack itemStack, int colorCount) {
        try {
            return ColorGetter.unsafeGetColors(itemStack, colorCount);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.debug("Failed to get color name for {}", (Object)itemStackInfo, (Object)e);
            return Collections.emptyList();
        }
    }

    private static List<Integer> unsafeGetColors(ItemStack itemStack, int colorCount) {
        Item item = itemStack.func_77973_b();
        if (itemStack.func_190926_b()) {
            return Collections.emptyList();
        }
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            Block block = itemBlock.func_179223_d();
            if (block == null) {
                return Collections.emptyList();
            }
            return ColorGetter.getBlockColors(block, colorCount);
        }
        return ColorGetter.getItemColors(itemStack, colorCount);
    }

    private static List<Integer> getItemColors(ItemStack itemStack, int colorCount) {
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        int renderColor = itemColors.func_186728_a(itemStack, 0);
        TextureAtlasSprite textureAtlasSprite = ColorGetter.getTextureAtlasSprite(itemStack);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return ColorGetter.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    private static List<Integer> getBlockColors(Block block, int colorCount) {
        IBlockState blockState = block.func_176223_P();
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        int renderColor = blockColors.func_186724_a(blockState, null, null, 0);
        TextureAtlasSprite textureAtlasSprite = ColorGetter.getTextureAtlasSprite(blockState);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return ColorGetter.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    public static List<Integer> getColors(TextureAtlasSprite textureAtlasSprite, int renderColor, int colorCount) {
        NativeImage bufferedImage = ColorGetter.getNativeImage(textureAtlasSprite);
        if (bufferedImage == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> colors = new ArrayList<Integer>(colorCount);
        int[][] palette = ColorThief.getPalette(bufferedImage, colorCount, 2, false);
        if (palette != null) {
            for (int[] colorInt : palette) {
                int red = (int)((float)(colorInt[0] - 1) * (float)(renderColor >> 16 & 0xFF) / 255.0f);
                int green = (int)((float)(colorInt[1] - 1) * (float)(renderColor >> 8 & 0xFF) / 255.0f);
                int blue = (int)((float)(colorInt[2] - 1) * (float)(renderColor & 0xFF) / 255.0f);
                red = MathUtil.clamp(red, 0, 255);
                green = MathUtil.clamp(green, 0, 255);
                blue = MathUtil.clamp(blue, 0, 255);
                int color = 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                colors.add(color);
            }
        }
        return colors;
    }

    @Nullable
    private static NativeImage getNativeImage(TextureAtlasSprite textureAtlasSprite) {
        int iconWidth = textureAtlasSprite.func_94211_a();
        int iconHeight = textureAtlasSprite.func_94216_b();
        int frameCount = textureAtlasSprite.func_110970_k();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return null;
        }
        NativeImage[] frames = textureAtlasSprite.field_195670_c;
        return frames[0];
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(IBlockState blockState) {
        Minecraft minecraft = Minecraft.func_71410_x();
        BlockRendererDispatcher blockRendererDispatcher = minecraft.func_175602_ab();
        BlockModelShapes blockModelShapes = blockRendererDispatcher.func_175023_a();
        TextureAtlasSprite textureAtlasSprite = blockModelShapes.func_178122_a(blockState);
        if (textureAtlasSprite instanceof MissingTextureSprite) {
            return null;
        }
        return textureAtlasSprite;
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(ItemStack itemStack) {
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        ItemModelMesher itemModelMesher = itemRenderer.func_175037_a();
        IBakedModel itemModel = itemModelMesher.func_178089_a(itemStack);
        TextureAtlasSprite particleTexture = itemModel.func_177554_e();
        if (particleTexture instanceof MissingTextureSprite) {
            return null;
        }
        return particleTexture;
    }
}

