/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.suffixtree;

import gnu.trove.TIntCollection;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.suffixtree.ISearchTree;

public class CombinedSearchTrees
implements ISearchTree {
    private final List<ISearchTree> searchTrees = new ArrayList<ISearchTree>();

    @Override
    public TIntSet search(String word) {
        TIntHashSet searchResults = new TIntHashSet(0);
        for (ISearchTree searchTree : this.searchTrees) {
            TIntSet search = searchTree.search(word);
            searchResults = CombinedSearchTrees.union((TIntSet)searchResults, search);
        }
        return searchResults;
    }

    public void addSearchTree(ISearchTree searchTree) {
        this.searchTrees.add(searchTree);
    }

    private static TIntSet union(TIntSet set1, TIntSet set2) {
        if (set1.size() > set2.size()) {
            set1.addAll((TIntCollection)set2);
            return set1;
        }
        set2.addAll((TIntCollection)set1);
        return set2;
    }
}

